/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui.widgets;

import forestry.core.gui.Drawable;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.NetworkUtil;
import forestry.database.DatabaseItem;
import forestry.database.gui.GuiDatabase;
import forestry.database.network.packets.PacketExtractItem;
import forestry.database.network.packets.PacketInsertItem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class WidgetDatabaseSlot
extends Widget {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("forestry", "textures/gui/database_inventory.png");
    public static final Drawable SLOT = new Drawable(TEXTURE_LOCATION, 218, 0, 22, 22);
    public static final Drawable SLOT_SELECTED = new Drawable(TEXTURE_LOCATION, 218, 22, 22, 22);
    private int xPos;
    private int yPos;
    private boolean isEmpty = false;
    private int databaseIndex = -1;
    private boolean ignoreMouseUp = false;
    private boolean mouseOver;

    public WidgetDatabaseSlot(WidgetManager manager) {
        super(manager, 0, 0);
    }

    public void update(int xPos, int yPos, int databaseIndex, boolean isEmpty) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.databaseIndex = databaseIndex;
        this.isEmpty = isEmpty;
    }

    public int getDatabaseIndex() {
        return this.databaseIndex;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.xPos && mouseX <= this.xPos + this.width && mouseY >= this.yPos && mouseY <= this.yPos + this.height;
    }

    @Override
    public void draw(int startX, int startY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.manager.minecraft.field_71446_o.func_110577_a(TEXTURE_LOCATION);
        Drawable texture = SLOT;
        if (this.isSelected()) {
            texture = SLOT_SELECTED;
        }
        texture.draw(startX + this.xPos - 3, startY + this.yPos - 3);
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.func_190926_b()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            RenderHelper.func_74520_c();
            GuiUtil.drawItemStack(this.manager.gui, itemStack, startX + this.xPos, startY + this.yPos);
            RenderHelper.func_74518_a();
        }
        if (this.mouseOver) {
            this.drawMouseOver();
        }
    }

    private void drawMouseOver() {
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.manager.gui.func_73733_a(this.xPos, this.yPos, this.xPos + this.width, this.yPos + this.height, -2130706433, -2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.mouseOver = this.isMouseOver(mouseX, mouseY);
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0 && mouseButton != 1 && mouseButton != 2 || !this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        GuiDatabase gui = (GuiDatabase)this.manager.gui;
        DatabaseItem item = gui.getItem(this.databaseIndex);
        if (item == null) {
            return;
        }
        if (GuiScreen.func_146271_m() && mouseButton == 0) {
            gui.getManager().setSelectedSlot(this.databaseIndex);
            return;
        }
        this.ignoreMouseUp = true;
        byte flags = 0;
        if (GuiScreen.func_146272_n()) {
            flags = (byte)(flags | 2);
        }
        if (mouseButton == 1) {
            flags = (byte)(flags | 1);
        } else if (mouseButton == 2) {
            flags = (byte)(flags | 4);
        }
        NetworkUtil.sendToServer(new PacketExtractItem(item.invIndex, flags));
    }

    @Override
    public boolean handleMouseRelease(int mouseX, int mouseY, int eventType) {
        if (!this.isMouseOver(mouseX, mouseY) || this.ignoreMouseUp || eventType != 0 && eventType != 1 || this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.ignoreMouseUp = false;
            return false;
        }
        GuiDatabase gui = (GuiDatabase)this.manager.gui;
        DatabaseItem item = gui.getItem(this.databaseIndex);
        if (item == null) {
            return false;
        }
        NetworkUtil.sendToServer(new PacketInsertItem(eventType == 1));
        return true;
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        ItemStack itemStack = this.getItemStack();
        ToolTip tip = new ToolTip();
        if (!itemStack.func_190926_b()) {
            tip.add(itemStack.func_82840_a((EntityPlayer)player, (ITooltipFlag)(minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        }
        return tip;
    }

    public boolean isSelected() {
        if (!this.isEmpty) {
            return false;
        }
        return ((GuiDatabase)this.manager.gui).getItem(this.databaseIndex) == ((GuiDatabase)this.manager.gui).getSelectedItem();
    }

    public ItemStack getItemStack() {
        if (!this.isEmpty) {
            return ItemStack.field_190927_a;
        }
        DatabaseItem item = ((GuiDatabase)this.manager.gui).getItem(this.databaseIndex);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return item.itemStack;
    }
}

