/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.core.recipes.RecipeUtil;
import forestry.energy.blocks.BlockRegistryEnergy;
import forestry.energy.proxy.ProxyEnergy;
import forestry.modules.BlankForestryModule;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.SidedProxy;

@ForestryModule(containerID="forestry", moduleID="energy", name="Energy", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.energy.description")
public class ModuleEnergy
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.energy.proxy.ProxyEnergyClient", serverSide="forestry.energy.proxy.ProxyEnergy")
    public static ProxyEnergy proxy;
    @Nullable
    public static BlockRegistryEnergy blocks;

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryEnergy();
    }

    @Override
    public void doInit() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        ModuleEnergy.blocks.peatEngine.init();
        ModuleEnergy.blocks.biogasEngine.init();
        if (ForestryAPI.activeMode.getBooleanSetting("energy.engine.clockwork")) {
            ModuleEnergy.blocks.clockworkEngine.init();
        }
    }

    @Override
    public void registerRecipes() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        RecipeUtil.addRecipe("peat_engine", new ItemStack((Block)ModuleEnergy.blocks.peatEngine), "###", " X ", "YVY", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearCopper", Character.valueOf('V'), Blocks.field_150331_J);
        RecipeUtil.addRecipe("biogas_engine", new ItemStack((Block)ModuleEnergy.blocks.biogasEngine), "###", " X ", "YVY", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearBronze", Character.valueOf('V'), Blocks.field_150331_J);
        if (ForestryAPI.activeMode.getBooleanSetting("energy.engine.clockwork")) {
            RecipeUtil.addRecipe("clockwork_engine", new ItemStack((Block)ModuleEnergy.blocks.clockworkEngine), "###", " X ", "ZVY", Character.valueOf('#'), "plankWood", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), Items.field_151113_aN, Character.valueOf('Z'), "gearCopper", Character.valueOf('V'), Blocks.field_150331_J);
        }
    }
}

