/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerFermenter;
import forestry.factory.gui.GuiFermenter;
import forestry.factory.inventory.InventoryFermenter;
import forestry.factory.recipes.FermenterRecipeManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFermenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile {
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    @Nullable
    private IFermenterRecipe currentRecipe;
    private float currentResourceModifier;
    private int fermentationTime = 0;
    private int fermentationTotalTime = 0;
    private int fuelBurnTime = 0;
    private int fuelTotalTime = 0;
    private int fuelCurrentFerment = 0;

    public TileFermenter() {
        super(2000, 8000);
        this.setEnergyPerWorkCycle(4200);
        this.setInternalInventory(new InventoryFermenter(this));
        this.resourceTank = new FilteredTank(10000, true, false);
        this.resourceTank.setFilters(FermenterRecipeManager.recipeFluidInputs);
        this.productTank = new FilteredTank(10000, false, true);
        this.productTank.setFilters(FermenterRecipeManager.recipeFluidOutputs);
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("FermentationTime", this.fermentationTime);
        nbttagcompound.func_74768_a("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.func_74768_a("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.func_74768_a("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.func_74768_a("FuelCurrentFerment", this.fuelCurrentFerment);
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fermentationTime = nbttagcompound.func_74762_e("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.func_74762_e("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.func_74762_e("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.func_74762_e("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.func_74762_e("FuelCurrentFerment");
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 4);
            FluidStack fluidStack = this.productTank.getFluid();
            if (fluidStack != null) {
                FluidHelper.fillContainers(this.tankManager, (IInventory)this, 3, 2, fluidStack.getFluid(), true);
            }
        }
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            return false;
        }
        int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
        int productAmount = Math.round((float)fermented * this.currentRecipe.getModifier() * this.currentResourceModifier);
        this.productTank.fillInternal(new FluidStack(this.currentRecipe.getOutput(), productAmount), true);
        --this.fuelBurnTime;
        this.resourceTank.drain(fermented, true);
        this.fermentationTime -= fermented;
        if (this.fermentationTime > 0) {
            return false;
        }
        this.currentRecipe = null;
        return true;
    }

    private void checkRecipe() {
        if (this.currentRecipe != null) {
            return;
        }
        ItemStack resource = this.func_70301_a(0);
        FluidStack fluid = this.resourceTank.getFluid();
        if (fluid != null) {
            this.currentRecipe = FermenterRecipeManager.findMatchingRecipe(resource, fluid);
        }
        this.fermentationTime = this.currentRecipe == null ? 0 : this.currentRecipe.getFermentationValue();
        this.fermentationTotalTime = this.fermentationTime;
        if (this.currentRecipe != null) {
            this.currentResourceModifier = TileFermenter.determineResourceMod(resource);
            this.func_70298_a(0, 1);
        }
    }

    private void checkFuel() {
        FermenterFuel fermenterFuel;
        ItemStack fuel;
        if (this.fuelBurnTime <= 0 && !(fuel = this.func_70301_a(1)).func_190926_b() && (fermenterFuel = FuelManager.fermenterFuel.get(fuel)) != null) {
            this.fuelBurnTime = this.fuelTotalTime = fermenterFuel.getBurnDuration();
            this.fuelCurrentFerment = fermenterFuel.getFermentPerCycle();
            this.func_70298_a(1, 1);
        }
    }

    private static float determineResourceMod(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof IVariableFermentable)) {
            return 1.0f;
        }
        return ((IVariableFermentable)itemstack.func_77973_b()).getFermentationModifier(itemstack);
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        ItemStack fermentationStack = this.func_70301_a(0);
        if (fermentationStack.func_190926_b()) {
            return false;
        }
        return (float)fermentationStack.func_190916_E() / (float)fermentationStack.func_77976_d() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        ItemStack fuelStack = this.func_70301_a(1);
        if (fuelStack.func_190926_b()) {
            return false;
        }
        return (float)fuelStack.func_190916_E() / (float)fuelStack.func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        this.checkFuel();
        int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasFuel = this.fuelBurnTime > 0;
        boolean hasResource = this.fermentationTime > 0 || !this.func_70301_a(0).func_190926_b();
        FluidStack drained = this.resourceTank.drain(fermented, false);
        boolean hasFluidResource = drained != null && drained.amount == fermented;
        boolean hasFluidSpace = true;
        if (hasRecipe) {
            int productAmount = Math.round((float)fermented * this.currentRecipe.getModifier() * this.currentResourceModifier);
            Fluid output = this.currentRecipe.getOutput();
            FluidStack fluidStack = new FluidStack(output, productAmount);
            hasFluidSpace = this.productTank.fillInternal(fluidStack, false) == fluidStack.amount;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NO_FUEL);
        errorLogic.setCondition(!hasResource, EnumErrorCode.NO_RESOURCE);
        errorLogic.setCondition(!hasFluidResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasFluidSpace, EnumErrorCode.NO_SPACE_TANK);
        return hasRecipe && hasFuel && hasResource && hasFluidResource && hasFluidSpace;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fuelBurnTime);
        iCrafting.func_71112_a(container, 1, this.fuelTotalTime);
        iCrafting.func_71112_a(container, 2, this.fermentationTime);
        iCrafting.func_71112_a(container, 3, this.fermentationTotalTime);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiFermenter(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerFermenter(player.field_71071_by, this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }
}

