/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.base.Predicate;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.utils.VectUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class FarmLogic
implements IFarmLogic {
    private final EntitySelectorFarm entitySelectorFarm = new EntitySelectorFarm(this);
    protected boolean isManual;

    @Override
    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextureMap() {
        return TextureMap.field_110575_b;
    }

    @Override
    public abstract ItemStack getIconItemStack();

    public abstract boolean isAcceptedWindfall(ItemStack var1);

    protected final boolean isWaterSourceBlock(World world, BlockPos position) {
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150355_j;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, FarmDirection farmDirection, int step) {
        return VectUtil.scale(farmDirection.getFacing().func_176730_m(), step).func_177971_a((Vec3i)pos);
    }

    private static AxisAlignedBB getHarvestBox(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        BlockPos coords = farmHousing.getCoords();
        Vec3i area = farmHousing.getArea();
        Vec3i offset = farmHousing.getOffset();
        BlockPos min = coords.func_177971_a(offset);
        BlockPos max = min.func_177971_a(area);
        int maxY = max.func_177956_o();
        if (toWorldHeight) {
            maxY = world.func_72800_K();
        }
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)maxY, (double)max.func_177952_p());
    }

    protected NonNullList<ItemStack> collectEntityItems(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        AxisAlignedBB harvestBox = FarmLogic.getHarvestBox(world, farmHousing, toWorldHeight);
        List entityItems = world.func_175647_a(EntityItem.class, harvestBox, (Predicate)this.entitySelectorFarm);
        NonNullList stacks = NonNullList.func_191196_a();
        for (EntityItem entity : entityItems) {
            ItemStack contained = entity.func_92059_d();
            stacks.add((Object)contained.func_77946_l());
            entity.func_70106_y();
        }
        return stacks;
    }

    public String toString() {
        return this.getName();
    }

    private static class EntitySelectorFarm
    implements Predicate<EntityItem> {
        private final FarmLogic farmLogic;

        public EntitySelectorFarm(FarmLogic farmLogic) {
            this.farmLogic = farmLogic;
        }

        public boolean apply(@Nullable EntityItem entity) {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            if (entity.getEntityData().func_74767_n("PreventRemoteMovement")) {
                return false;
            }
            ItemStack contained = entity.func_92059_d();
            return this.farmLogic.isAcceptedGermling(contained) || this.farmLogic.isAcceptedWindfall(contained);
        }
    }
}

