/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.ForestryAPI;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmInventory;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import forestry.farming.multiblock.FarmController;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryFarm
extends InventoryAdapterRestricted
implements IFarmInventory {
    public static final int SLOT_RESOURCES_1 = 0;
    public static final int SLOT_RESOURCES_COUNT = 6;
    public static final int SLOT_GERMLINGS_1 = 6;
    public static final int SLOT_GERMLINGS_COUNT = 6;
    public static final int SLOT_PRODUCTION_1 = 12;
    public static final int SLOT_PRODUCTION_COUNT = 8;
    public static final int SLOT_FERTILIZER = 20;
    public static final int SLOT_FERTILIZER_COUNT = 1;
    public static final int SLOT_CAN = 21;
    public static final int SLOT_CAN_COUNT = 1;
    public static final int SLOT_COUNT = 22;
    private static final int FERTILIZER_MODIFIER = ForestryAPI.activeMode.getIntegerSetting("farms.fertilizer.modifier");
    private final FarmController farmController;
    private final IInventory resourcesInventory;
    private final IInventory germlingsInventory;
    private final IInventory productInventory;
    private final IInventory fertilizerInventory;

    public InventoryFarm(FarmController farmController) {
        super(22, "Items");
        this.farmController = farmController;
        this.resourcesInventory = new InventoryMapper((IInventory)this, 0, 6);
        this.germlingsInventory = new InventoryMapper((IInventory)this, 6, 6);
        this.productInventory = new InventoryMapper((IInventory)this, 12, 8);
        this.fertilizerInventory = new InventoryMapper((IInventory)this, 20, 1);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 20, 1)) {
            return this.acceptsAsFertilizer(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 6, 6)) {
            return this.acceptsAsGermling(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 6)) {
            return this.acceptsAsResource(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 21, 1)) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluid != null && this.farmController.getTankManager().canFillFluidType(fluid);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack stack, EnumFacing side) {
        return SlotUtil.isSlotInRange(slotIndex, 12, 8);
    }

    @Override
    public boolean hasResources(NonNullList<ItemStack> resources) {
        return InventoryUtil.contains(this.resourcesInventory, resources);
    }

    @Override
    public void removeResources(NonNullList<ItemStack> resources) {
        InventoryUtil.removeSets(this.resourcesInventory, 1, resources, null, false, true, false, true);
    }

    @Override
    public boolean acceptsAsGermling(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        for (FarmDirection farmDirection : FarmDirection.values()) {
            IFarmLogic logic = this.farmController.getFarmLogic(farmDirection);
            if (!logic.isAcceptedGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsResource(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        for (FarmDirection farmDirection : FarmDirection.values()) {
            IFarmLogic logic = this.farmController.getFarmLogic(farmDirection);
            if (!logic.isAcceptedResource(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAsFertilizer(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        return ForestryAPI.farmRegistry.getFertilizeValue(itemstack) > 0;
    }

    @Override
    public IInventory getProductInventory() {
        return this.productInventory;
    }

    @Override
    public IInventory getGermlingsInventory() {
        return this.germlingsInventory;
    }

    @Override
    public IInventory getResourcesInventory() {
        return this.resourcesInventory;
    }

    @Override
    public IInventory getFertilizerInventory() {
        return this.fertilizerInventory;
    }

    public void drainCan(TankManager tankManager) {
        FluidHelper.drainContainers(tankManager, (IInventory)this, 21);
    }

    public boolean plantGermling(IFarmable germling, EntityPlayer player, BlockPos pos) {
        for (int i = 0; i < this.germlingsInventory.func_70302_i_(); ++i) {
            ItemStack germlingStack = this.germlingsInventory.func_70301_a(i);
            if (germlingStack.func_190926_b() || !germling.isGermling(germlingStack) || !germling.plantSaplingAt(player, germlingStack, player.field_70170_p, pos)) continue;
            this.germlingsInventory.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    public void addProduce(ItemStack produce) {
        int added = InventoryUtil.addStack(this.productInventory, produce, true);
        produce.func_190918_g(added);
    }

    public void stowHarvest(Iterable<ItemStack> harvested, Stack<ItemStack> pendingProduce) {
        for (ItemStack harvest : harvested) {
            int added = InventoryUtil.addStack(this.productInventory, harvest, true);
            harvest.func_190918_g(added);
            if (harvest.func_190926_b()) continue;
            pendingProduce.push(harvest);
        }
    }

    public boolean tryAddPendingProduce(Stack<ItemStack> pendingProduce) {
        ItemStack next;
        IInventory productInventory = this.getProductInventory();
        boolean added = InventoryUtil.tryAddStack(productInventory, next = pendingProduce.peek(), true, true);
        if (added) {
            pendingProduce.pop();
        }
        return added;
    }

    public int getFertilizerValue() {
        ItemStack fertilizerStack = this.func_70301_a(20);
        if (fertilizerStack.func_190926_b()) {
            return 0;
        }
        int fertilizerValue = ForestryAPI.farmRegistry.getFertilizeValue(fertilizerStack);
        if (fertilizerValue > 0) {
            return fertilizerValue * FERTILIZER_MODIFIER;
        }
        return 0;
    }

    public boolean useFertilizer() {
        ItemStack fertilizer = this.func_70301_a(20);
        if (this.acceptsAsFertilizer(fertilizer)) {
            this.func_70298_a(20, 1);
            return true;
        }
        return false;
    }
}

