/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.multiblock.IGreenhouseController;
import forestry.greenhouse.api.greenhouse.IGreenhouseHelper;
import forestry.greenhouse.api.greenhouse.IGreenhouseLogic;
import forestry.greenhouse.api.greenhouse.IGreenhouseLogicFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class GreenhouseHelper
implements IGreenhouseHelper {
    private List<IGreenhouseLogicFactory> factories = new ArrayList<IGreenhouseLogicFactory>();
    private Map<String, GreenhouseWindowGlass> windowGlasses = new HashMap<String, GreenhouseWindowGlass>();

    @Override
    public void registerWindowGlass(String name, ItemStack item, String texture) {
        this.windowGlasses.put(name, new GreenhouseWindowGlass(name, texture, item));
    }

    @Override
    public ItemStack getGlassItem(String name) {
        GreenhouseWindowGlass glass = this.windowGlasses.get(name);
        if (glass == null) {
            return ItemStack.field_190927_a;
        }
        return glass.item.func_77946_l();
    }

    @Override
    public String getGlassTexture(String name) {
        GreenhouseWindowGlass glass = this.windowGlasses.get(name);
        if (glass == null) {
            return "minecraft:blocks/glass";
        }
        return glass.texture;
    }

    @Override
    public Collection<String> getWindowGlasses() {
        return this.windowGlasses.keySet();
    }

    @Override
    public void registerLogic(IGreenhouseLogicFactory logicFactory) {
        this.factories.add(logicFactory);
    }

    @Override
    public Collection<IGreenhouseLogic> createLogics(IGreenhouseController controller) {
        ArrayList<IGreenhouseLogic> logics = new ArrayList<IGreenhouseLogic>();
        for (IGreenhouseLogicFactory factory : this.factories) {
            logics.add(factory.createLogic(controller));
        }
        return logics;
    }

    private final class GreenhouseWindowGlass {
        ItemStack item;
        String name;
        String texture;

        public GreenhouseWindowGlass(String name, String texture, ItemStack item) {
            this.name = name;
            this.texture = texture;
            this.item = item;
        }
    }
}

