/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.greenhouse.blocks.BlockGreenhouseType;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum BlockGreenhouseSprite {
    TOP("top"),
    GEARS("gears"),
    BORDER("border"),
    BORDER_TOP("border_top"),
    BORDER_TOP_CENTER("border_top_center"),
    HYGRO("hygroregulator"),
    CONTROL("control"),
    GREENHOUSE_SCREEN_0("greenhouse_screen_0"),
    GREENHOUSE_SCREEN_1("greenhouse_screen_1");

    public static final BlockGreenhouseSprite[] VALUES;
    private static EnumMap<BlockGreenhouseSprite, TextureAtlasSprite> sprites;
    private static TextureAtlasSprite missingImage;
    private final String spriteName;

    private BlockGreenhouseSprite(String spriteName) {
        this.spriteName = spriteName;
    }

    public static void registerSprites() {
        sprites = new EnumMap(BlockGreenhouseSprite.class);
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (BlockGreenhouseSprite sprite : VALUES) {
            ResourceLocation location = new ResourceLocation("forestry", "blocks/greenhouse/" + sprite.spriteName);
            TextureAtlasSprite textureAtlasSprite = map.func_174942_a(location);
            sprites.put(sprite, textureAtlasSprite);
        }
        missingImage = map.field_94249_f;
    }

    public static TextureAtlasSprite getSprite(BlockGreenhouseType type, @Nullable EnumFacing facing, @Nullable IBlockState state, int layer) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        switch (type) {
            case BORDER: {
                if (facing == EnumFacing.UP) {
                    return sprites.get((Object)BORDER_TOP);
                }
                if (facing == EnumFacing.DOWN) {
                    return sprites.get((Object)TOP);
                }
                return sprites.get((Object)BORDER);
            }
            case BORDER_CENTER: {
                if (facing == EnumFacing.UP) {
                    if (layer == 0) {
                        return sprites.get((Object)BORDER_TOP_CENTER);
                    }
                    return sprites.get((Object)GREENHOUSE_SCREEN_1);
                }
                return sprites.get((Object)BORDER);
            }
            case GEARBOX: {
                if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                    return sprites.get((Object)TOP);
                }
                return sprites.get((Object)GEARS);
            }
            case CONTROL: {
                if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                    return sprites.get((Object)TOP);
                }
                return sprites.get((Object)CONTROL);
            }
            case SCREEN: {
                if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                    return sprites.get((Object)TOP);
                }
                if (layer == 0) {
                    return sprites.get((Object)GREENHOUSE_SCREEN_0);
                }
                return sprites.get((Object)GREENHOUSE_SCREEN_1);
            }
            case PLAIN: {
                if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                    return sprites.get((Object)TOP);
                }
                if (layer != 0) break;
                return missingImage;
            }
        }
        return map.func_110572_b("forestry:blocks/ash_brick");
    }

    static {
        VALUES = BlockGreenhouseSprite.values();
    }
}

