/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.camouflage;

import com.google.common.collect.Lists;
import forestry.api.core.ICamouflageAccess;
import forestry.api.core.ICamouflageItemHandler;
import forestry.core.utils.Log;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class CamouflageAccess
implements ICamouflageAccess {
    private static final List<ICamouflageItemHandler> camouflageItemHandlers = Lists.newArrayList();
    private static final List<ItemStack> camouflageItemBlacklist = Lists.newArrayList();
    private static final List<String> blacklistedMods = Lists.newArrayList();

    @Override
    public void registerItemHandler(ICamouflageItemHandler itemHandler) {
        if (!camouflageItemHandlers.contains(itemHandler)) {
            camouflageItemHandlers.add(itemHandler);
        } else {
            Log.error("Fail to register a camouflage item handler, because the handler is already registered. The handler is form the mod with the ID: " + Loader.instance().activeModContainer().getModId() + ".", new Object[0]);
        }
    }

    @Override
    public List<ICamouflageItemHandler> getItemHandlers() {
        return camouflageItemHandlers;
    }

    @Override
    public void addItemToBlackList(ItemStack camouflageBlock) {
        Block block = Block.func_149634_a((Item)camouflageBlock.func_77973_b());
        if (block == Blocks.field_150350_a) {
            Log.error("Fail to add camouflage block item to the black list: because it has no block.", new Object[0]);
            return;
        }
        for (ItemStack camouflageBlacklisted : camouflageItemBlacklist) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            Log.error("Fail to add camouflage block item to the black list, because it is already registered: " + camouflageBlock + ".", new Object[0]);
            return;
        }
        camouflageItemBlacklist.add(camouflageBlock);
    }

    @Override
    public void addModIdToBlackList(String modID) {
        if (!blacklistedMods.contains(modID)) {
            blacklistedMods.add(modID);
        }
    }

    @Override
    public boolean isItemBlackListed(ItemStack camouflageBlock) {
        if (camouflageBlock.func_190926_b() || Block.func_149634_a((Item)camouflageBlock.func_77973_b()) == Blocks.field_150350_a) {
            return false;
        }
        String modId = camouflageBlock.func_77973_b().getRegistryName().func_110624_b();
        if (blacklistedMods.contains(modId)) {
            return true;
        }
        for (ItemStack camouflageBlacklisted : camouflageItemBlacklist) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICamouflageItemHandler getHandler(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (ICamouflageItemHandler handler : camouflageItemHandlers) {
            if (!handler.canHandle(stack)) continue;
            return handler;
        }
        return null;
    }
}

