/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.greenhouse.camouflage.CamouflageHandlerType;
import forestry.greenhouse.network.packets.PacketCamouflageSelection;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketCamouflageSelectionClient
extends PacketCamouflageSelection
implements IForestryPacketClient {
    public PacketCamouflageSelectionClient(ICamouflageHandler handler, CamouflageHandlerType handlerType) {
        super(handler, handlerType);
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.CAMOUFLAGE_SELECTION;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            CamouflageHandlerType handlerType = CamouflageHandlerType.values()[data.readShort()];
            ItemStack camouflageStack = data.func_150791_c();
            TileEntity tile = TileUtil.getTile((IBlockAccess)player.field_70170_p, pos);
            switch (handlerType) {
                case STRUCTURE: {
                    if (!(tile instanceof IMultiblockComponent)) {
                        return;
                    }
                    IMultiblockController controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController();
                    if (!(controller instanceof ICamouflageHandler)) {
                        return;
                    }
                    ICamouflageHandler handler = (ICamouflageHandler)((Object)controller);
                    if (!handler.setCamouflageBlock(camouflageStack, false)) {
                        return;
                    }
                    for (IMultiblockComponent comp : controller.getComponents()) {
                        if (!(comp instanceof ICamouflagedTile)) continue;
                        ICamouflagedTile camBlock = (ICamouflagedTile)((Object)comp);
                        BlockPos coordinates = camBlock.getCoordinates();
                        World world = camBlock.getWorldObj();
                        world.func_175704_b(coordinates, coordinates);
                    }
                    break;
                }
                case TILE: {
                    if (!(tile instanceof ICamouflageHandler)) break;
                    ICamouflageHandler handler = (ICamouflageHandler)tile;
                    if (!handler.setCamouflageBlock(camouflageStack, false)) {
                        return;
                    }
                    player.field_70170_p.func_175704_b(pos, pos);
                }
            }
        }
    }
}

