/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.network.packets;

import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProviderClient;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProviderServer;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketGreenhouseData
extends ForestryPacket
implements IForestryPacketClient {
    BlockPos pos;
    GreenhouseProviderServer provider;

    public PacketGreenhouseData(BlockPos pos, GreenhouseProviderServer provider) {
        this.pos = pos;
        this.provider = provider;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GREENHOUSE_DATA;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.func_179255_a(this.pos);
        this.provider.writeData(data);
    }

    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos pos = data.func_179259_c();
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)player.field_70170_p, pos, IGreenhouseComponent.class);
            if (controller == null) {
                return;
            }
            IGreenhouseProvider provider = controller.getProvider();
            if (provider instanceof GreenhouseProvider) {
                GreenhouseProviderClient providerClient = (GreenhouseProviderClient)provider;
                providerClient.readData(data);
            }
            GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
            manager.markProviderDirty(player.field_70170_p, controller.getProvider().getCenterPos(), provider);
        }
    }
}

