/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.items;

import forestry.api.mail.EnumPostage;
import forestry.core.items.ItemOverlay;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.init.Items;

public enum EnumStampDefinition implements ItemOverlay.IOverlayInfo
{
    P_1("1n", EnumPostage.P_1, "gemApatite", new Color(4885671), new Color(0xFFFFFF)),
    P_2("2n", EnumPostage.P_2, "ingotCopper", new Color(15255572), new Color(0xFFFFFF)),
    P_5("5n", EnumPostage.P_5, "ingotTin", new Color(10225415), new Color(0xFFFFFF)),
    P_10("10n", EnumPostage.P_10, "ingotGold", new Color(8114616), new Color(0xFFFFFF)),
    P_20("20n", EnumPostage.P_20, "gemDiamond", new Color(16748593), new Color(0xFFF7DD)),
    P_50("50n", EnumPostage.P_50, "gemEmerald", new Color(6566359), new Color(0xFFF7DD)),
    P_100("100n", EnumPostage.P_100, Items.field_151156_bN, new Color(14102970), new Color(0xFFF7DD));

    public static final EnumStampDefinition[] VALUES;
    private static final Map<EnumPostage, EnumStampDefinition> postageMap;
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final Object craftingIngredient;
    private final EnumPostage postage;

    private EnumStampDefinition(String name, EnumPostage postage, Object crafting, Color primaryColor, Color secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.craftingIngredient = crafting;
        this.postage = postage;
    }

    public EnumPostage getPostage() {
        return this.postage;
    }

    public Object getCraftingIngredient() {
        return this.craftingIngredient;
    }

    @Override
    public String getUid() {
        return this.name;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Override
    public boolean isSecret() {
        return false;
    }

    public static EnumStampDefinition getFromPostage(EnumPostage postage) {
        return postageMap.get((Object)postage);
    }

    static {
        VALUES = EnumStampDefinition.values();
        postageMap = new EnumMap<EnumPostage, EnumStampDefinition>(EnumPostage.class);
        for (EnumStampDefinition stampDefinition : VALUES) {
            postageMap.put(stampDefinition.getPostage(), stampDefinition);
        }
    }
}

