/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import com.google.common.collect.ImmutableList;
import forestry.api.modules.IForestryModule;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.network.IPacketRegistry;
import forestry.core.utils.Log;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;

public class InternalModuleHandler {
    protected final Set<BlankForestryModule> modules = new LinkedHashSet<BlankForestryModule>();
    protected final Set<IForestryModule> disabledModules = new LinkedHashSet<IForestryModule>();
    protected final ModuleManager moduleManager;
    private Stage stage = Stage.SETUP;

    public InternalModuleHandler(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void addModules(Collection<IForestryModule> modules, Collection<IForestryModule> disabledModules) {
        if (this.stage != Stage.SETUP) {
            throw new RuntimeException("Tried to register Modules outside of SETUP");
        }
        for (IForestryModule module : modules) {
            if (!(module instanceof BlankForestryModule)) continue;
            this.modules.add((BlankForestryModule)module);
        }
        this.disabledModules.addAll(disabledModules);
    }

    public Stage getStage() {
        return this.stage;
    }

    public void runSetup() {
        this.stage = Stage.SETUP;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Setup API Start: {}", iForestryModule);
            iForestryModule.setupAPI();
            Log.debug("Setup API Complete: {}", iForestryModule);
        }
        this.stage = Stage.SETUP_DISABLED;
        for (IForestryModule iForestryModule : this.disabledModules) {
            Log.debug("Disabled-Setup Start: {}", iForestryModule);
            iForestryModule.disabledSetupAPI();
            Log.debug("Disabled-Setup Complete: {}", iForestryModule);
        }
        this.stage = Stage.REGISTER;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Register Items and Blocks Start: {}", iForestryModule);
            iForestryModule.registerItemsAndBlocks();
            Log.debug("Register Items and Blocks Complete: {}", iForestryModule);
        }
    }

    public void runPreInit(Side side) {
        this.stage = Stage.PRE_INIT;
        for (BlankForestryModule module : this.modules) {
            Log.debug("Pre-Init Start: {}", module);
            this.registerHandlers(module, side);
            module.preInit();
            if (this.moduleManager.isModuleEnabled("forestry_compat", "buildcraft.statements")) {
                module.registerTriggers();
            }
            Log.debug("Pre-Init Complete: {}", module);
        }
    }

    private void registerHandlers(BlankForestryModule module, Side side) {
        IResupplyHandler resupplyHandler;
        ISaveEventHandler saveHandler;
        IPickupHandler pickupHandler;
        Log.debug("Registering Handlers for Module: {}", module);
        IPacketRegistry packetRegistry = module.getPacketRegistry();
        if (packetRegistry != null) {
            packetRegistry.registerPacketsServer();
            if (side == Side.CLIENT) {
                packetRegistry.registerPacketsClient();
            }
        }
        if ((pickupHandler = module.getPickupHandler()) != null) {
            ModuleManager.pickupHandlers.add(pickupHandler);
        }
        if ((saveHandler = module.getSaveEventHandler()) != null) {
            ModuleManager.saveEventHandlers.add(saveHandler);
        }
        if ((resupplyHandler = module.getResupplyHandler()) != null) {
            ModuleManager.resupplyHandlers.add(resupplyHandler);
        }
    }

    public void runInit() {
        this.stage = Stage.INIT;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Init Start: {}", iForestryModule);
            iForestryModule.doInit();
            iForestryModule.registerRecipes();
            Log.debug("Init Complete: {}", iForestryModule);
        }
    }

    public void runPostInit() {
        this.stage = Stage.POST_INIT;
        for (IForestryModule iForestryModule : this.modules) {
            Log.debug("Post-Init Start: {}", iForestryModule);
            iForestryModule.postInit();
            Log.debug("Post-Init Complete: {}", iForestryModule);
        }
        this.stage = Stage.FINISHED;
    }

    public void runRegisterBackpacksAndCrates() {
        this.stage = Stage.BACKPACKS_CRATES;
        for (BlankForestryModule module : this.modules) {
            if (this.moduleManager.isModuleEnabled("forestry", "backpacks")) {
                Log.debug("Backpacks Start: {}", module);
                module.registerBackpackItems();
                Log.debug("Backpacks Complete: {}", module);
            }
            if (!this.moduleManager.isModuleEnabled("forestry", "crates")) continue;
            Log.debug("Crates Start: {}", module);
            module.registerCrates();
            Log.debug("Crates Complete: {}", module);
        }
    }

    public void processIMCMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            for (BlankForestryModule module : this.modules) {
                if (module.processIMCMessage(message)) break;
            }
        }
    }

    public void populateChunk(IChunkGenerator chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        for (BlankForestryModule module : this.modules) {
            module.populateChunk(chunkProvider, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    public void decorateBiome(World world, Random rand, BlockPos pos) {
        for (BlankForestryModule module : this.modules) {
            module.decorateBiome(world, rand, pos);
        }
    }

    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        for (BlankForestryModule module : this.modules) {
            module.populateChunkRetroGen(world, rand, chunkX, chunkZ);
        }
    }

    public List<ItemStack> getHiddenItems() {
        ArrayList<ItemStack> hiddenItems = new ArrayList<ItemStack>();
        for (BlankForestryModule module : this.modules) {
            module.getHiddenItems(hiddenItems);
        }
        return hiddenItems;
    }

    public static enum Stage {
        SETUP,
        SETUP_DISABLED,
        REGISTER,
        PRE_INIT,
        BACKPACKS_CRATES,
        INIT,
        POST_INIT,
        FINISHED;

    }
}

