/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import com.google.common.base.Preconditions;
import forestry.api.core.IModelManager;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.config.Config;
import forestry.core.gui.GuiHandler;
import forestry.core.inventory.ItemHandlerInventoryManipulator;
import forestry.core.inventory.ItemInventory;
import forestry.core.inventory.StandardStackFilters;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemWithGui;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import forestry.storage.BackpackMode;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.GuiBackpack;
import forestry.storage.gui.GuiBackpackT2;
import forestry.storage.inventory.ItemInventoryBackpack;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemBackpack
extends ItemWithGui
implements IColoredItem {
    private final IBackpackDefinition definition;
    private final EnumBackpackType type;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation[] models;

    public ItemBackpack(IBackpackDefinition definition, EnumBackpackType type) {
        Preconditions.checkNotNull((Object)definition, (Object)"Backpack must have a backpack definition.");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Backpack must have a backpack type.");
        this.definition = definition;
        this.type = type;
    }

    public IBackpackDefinition getDefinition() {
        return this.definition;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    protected void openGui(EntityPlayer entityplayer) {
        GuiHandler.openGui(entityplayer, this, (short)this.type.ordinal());
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!playerIn.func_70093_af()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        ItemBackpack.switchMode(heldItem);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ItemBackpack.getInventoryHit(worldIn, pos, facing) != null) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af()) {
            ItemStack heldItem = player.func_184586_b(hand);
            return this.evaluateTileHit(heldItem, player, world, pos, side) ? EnumActionResult.PASS : EnumActionResult.FAIL;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public static void tryStowing(EntityPlayer player, ItemStack backpackStack, ItemStack stack) {
        if (ItemBackpack.getMode(backpackStack) == BackpackMode.LOCKED) {
            return;
        }
        ItemBackpack backpack = (ItemBackpack)backpackStack.func_77973_b();
        ItemInventoryBackpack inventory = new ItemInventoryBackpack(player, backpack.getBackpackSize(), backpackStack);
        if (MinecraftForge.EVENT_BUS.post((Event)new BackpackStowEvent(player, backpack.getDefinition(), inventory, stack))) {
            return;
        }
        if (stack.func_190926_b()) {
            return;
        }
        IItemHandler itemHandler = inventory.getItemHandler();
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(itemHandler);
        ItemStack remainder = manipulator.addStack(stack);
        stack.func_190920_e(remainder == null ? 0 : remainder.func_190916_E());
    }

    private static void switchMode(ItemStack itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        int nextMode = mode.ordinal() + 1;
        if (!Config.enableBackpackResupply && nextMode == BackpackMode.RESUPPLY.ordinal()) {
            ++nextMode;
        }
        itemstack.func_77964_b(nextMode %= BackpackMode.values().length);
    }

    @Nullable
    private static IItemHandler getInventoryHit(World world, BlockPos pos, EnumFacing side) {
        TileEntity targeted = TileUtil.getTile((IBlockAccess)world, pos);
        return TileUtil.getInventoryFromTile(targeted, side);
    }

    private boolean evaluateTileHit(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IItemHandler inventory = ItemBackpack.getInventoryHit(world, pos, side);
        if (inventory != null) {
            if (inventory.getSlots() <= 0) {
                return true;
            }
            if (!world.field_72995_K) {
                ItemInventoryBackpack backpackInventory = new ItemInventoryBackpack(player, this.getBackpackSize(), stack);
                BackpackMode mode = ItemBackpack.getMode(stack);
                if (mode == BackpackMode.RECEIVE) {
                    this.receiveFromChest(backpackInventory, inventory);
                } else {
                    ItemBackpack.transferToChest(backpackInventory, inventory);
                }
            }
            return true;
        }
        return false;
    }

    private static void transferToChest(ItemInventoryBackpack backpackInventory, IItemHandler target) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(backpackInventory.getItemHandler());
        manipulator.transferStacks(target, StandardStackFilters.ALL);
    }

    private void receiveFromChest(ItemInventoryBackpack backpackInventory, IItemHandler target) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(target);
        manipulator.transferStacks(backpackInventory.getItemHandler(), this.definition.getFilter());
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        int occupied = ItemInventory.getOccupiedSlotCount(itemstack);
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        String infoKey = mode.getUnlocalizedInfo();
        if (infoKey != null) {
            list.add(Translator.translateToLocal(infoKey));
        }
        list.add(Translator.translateToLocal("for.gui.slots").replaceAll("%USED", String.valueOf(occupied)).replaceAll("%SIZE", String.valueOf(this.getBackpackSize())));
    }

    public String func_77653_i(ItemStack itemstack) {
        return this.definition.getName(itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        EnumBackpackType t = this.type == EnumBackpackType.NATURALIST ? EnumBackpackType.NORMAL : this.type;
        String typeTag = "backpacks/" + t.toString().toLowerCase(Locale.ENGLISH);
        this.models = new ModelResourceLocation[4];
        this.models[0] = new ModelResourceLocation("forestry:" + typeTag + "_neutral", "inventory");
        this.models[1] = new ModelResourceLocation("forestry:" + typeTag + "_locked", "inventory");
        this.models[2] = new ModelResourceLocation("forestry:" + typeTag + "_receive", "inventory");
        this.models[3] = new ModelResourceLocation("forestry:" + typeTag + "_resupply", "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:" + typeTag + "_neutral")});
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:" + typeTag + "_locked")});
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:" + typeTag + "_receive")});
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:" + typeTag + "_resupply")});
        manager.registerItemModel(item, new BackpackMeshDefinition());
    }

    @Override
    public int getColorFromItemstack(ItemStack itemstack, int j) {
        if (j == 0) {
            return this.definition.getPrimaryColour();
        }
        if (j == 1) {
            return this.definition.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    private static int getSlotsForType(EnumBackpackType type) {
        switch (type) {
            case NATURALIST: {
                return 125;
            }
            case WOVEN: {
                return 45;
            }
        }
        return 15;
    }

    public static BackpackMode getMode(ItemStack backpack) {
        Preconditions.checkArgument((boolean)(backpack.func_77973_b() instanceof ItemBackpack), (Object)"Item must be a backpack");
        int meta = backpack.func_77952_i();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        Item newItem;
        Item oldItem = oldStack.func_77973_b();
        return oldItem != (newItem = newStack.func_77973_b()) || ItemBackpack.getMode(oldStack) != ItemBackpack.getMode(newStack);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, ItemStack heldItem, int data) {
        if (data > EnumBackpackType.values().length) {
            return null;
        }
        EnumBackpackType type = EnumBackpackType.values()[data];
        switch (type) {
            case NORMAL: {
                return new GuiBackpack(new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, heldItem));
            }
            case WOVEN: {
                return new GuiBackpackT2(new ContainerBackpack(player, ContainerBackpack.Size.T2, heldItem));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Container getContainer(EntityPlayer player, ItemStack heldItem, int data) {
        if (data > EnumBackpackType.values().length) {
            return null;
        }
        EnumBackpackType type = EnumBackpackType.values()[data];
        switch (type) {
            case NORMAL: {
                return new ContainerBackpack(player, ContainerBackpack.Size.DEFAULT, heldItem);
            }
            case WOVEN: {
                return new ContainerBackpack(player, ContainerBackpack.Size.T2, heldItem);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private class BackpackMeshDefinition
    implements ItemMeshDefinition {
        private BackpackMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            BackpackMode mode = ItemBackpack.getMode(stack);
            return ItemBackpack.this.models[mode.ordinal()];
        }
    }
}

