/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.guide;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.guide.GuideEntry;
import com.blakebr0.cucumber.guide.ItemGuide;
import com.blakebr0.cucumber.guide.page.PageHome;
import com.blakebr0.cucumber.registry.GuideRegistry;
import com.blakebr0.cucumber.util.Utils;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;

public class Guide {
    private ArrayList<GuideEntry> entries = new ArrayList();
    private String modid;
    private String name;
    private String registryName;
    private int color;
    private CreativeTabs tab;

    private Guide(String modid, String name, String registryName, int color, CreativeTabs tab) {
        this.modid = modid;
        this.name = name;
        this.registryName = registryName;
        this.color = color;
        this.tab = tab;
    }

    public static Guide create(String modid, String name, String registryName, int color, CreativeTabs tab) {
        return new Guide(modid, name, registryName, color, tab);
    }

    public void register() {
        GuideRegistry.register(this);
        Cucumber.REGISTRY.register(new ItemGuide(this.registryName, this.tab, this), this.registryName);
    }

    public String getModId() {
        return this.modid;
    }

    public String getName() {
        return Utils.localize(this.name);
    }

    public Guide addEntry(GuideEntry entry) {
        this.entries.add(entry);
        return this;
    }

    public ArrayList<GuideEntry> getEntries() {
        return this.entries;
    }

    public PageHome getHomePage() {
        return new PageHome();
    }
}

