/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    public static ItemStack to(Object obj) {
        if (obj instanceof Block) {
            return new ItemStack((Block)obj);
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj);
        }
        return StackHelper.getNull();
    }

    public static ItemStack to(Object obj, int amount) {
        if (obj instanceof Block) {
            return new ItemStack((Block)obj, amount, 0);
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, amount, 0);
        }
        return StackHelper.getNull();
    }

    public static ItemStack to(Object obj, int amount, int meta) {
        if (obj instanceof Block) {
            return new ItemStack((Block)obj, amount, meta);
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, amount, meta);
        }
        return StackHelper.getNull();
    }

    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            if (container && stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return StackHelper.getNull();
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack increase(ItemStack stack, int amount) {
        stack.func_190917_f(amount);
        return StackHelper.withSize(stack, stack.func_190916_E(), false);
    }

    public static ItemStack decrease(ItemStack stack, int amount, boolean container) {
        if (StackHelper.isNull(stack)) {
            return StackHelper.getNull();
        }
        stack.func_190918_g(amount);
        return StackHelper.withSize(stack, stack.func_190916_E(), container);
    }

    public static int getPlaceFromList(List<ItemStack> list, ItemStack stack, boolean wildcard) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if ((!StackHelper.isNull(stack) || !StackHelper.isNull(list.get(i))) && !StackHelper.areItemsEqual(stack, list.get(i), wildcard)) continue;
                return i;
            }
        }
        return -1;
    }

    public static ItemStack fromOre(String oreDict, int stackSize) {
        ItemStack item = ItemStack.field_190927_a;
        NonNullList list = OreDictionary.getOres((String)oreDict);
        if (!list.isEmpty()) {
            item = ((ItemStack)list.get(0)).func_77946_l();
            item.func_190920_e(stackSize);
        }
        return item;
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2, boolean wildcard) {
        return !StackHelper.isNull(stack1) && !StackHelper.isNull(stack2) && (stack1.func_77969_a(stack2) || wildcard && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE));
    }

    public static boolean isNull(ItemStack stack) {
        return stack.func_190926_b();
    }

    public static ItemStack getNull() {
        return ItemStack.field_190927_a;
    }
}

