/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorSplatter;
import biomesoplenty.common.world.generator.GeneratorSplotches;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;

public class BiomeGenCrag
extends BOPOverworldBiome {
    public BiomeGenCrag() {
        super("crag", new BOPBiome.PropsBuilder("Crag").withGuiColour(5209457).withTemperature(Float.valueOf(0.5f)).withRainfall(Float.valueOf(0.5f)));
        this.terrainSettings.avgHeight(100.0).heightVariation(80.0, 200.0).minHeight(40.0).sidewaysNoise(0.7f);
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.beachBiomeLocation = null;
        this.addWeight(BOPClimates.COLD_SWAMP, 2);
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_76752_A = Blocks.field_150351_n.func_176223_P();
        this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        IBlockPosQuery surface = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        this.addGenerator("overgrown_stone_patches", GeneratorStage.SAND, ((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)((GeneratorSplotches.Builder)new GeneratorSplotches.Builder().amountPerChunk(24.0f)).splotchSize(16).placeOn(surface)).replace(surface)).with(BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.OVERGROWN_STONE)))).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_SURFACE)).create());
        this.addGenerator("cobblestone_splatter", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(4.0f)).replace(surface)).with(Blocks.field_150347_e.func_176223_P())).create());
        this.addGenerator("stone_splatter", GeneratorStage.SAND, ((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)((GeneratorSplatter.Builder)new GeneratorSplatter.Builder().amountPerChunk(4.0f)).replace(surface)).with(Blocks.field_150348_b.func_176223_P())).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(4.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).generationAttempts(128)).create());
        grassGenerator.add("shortgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("dampgrass", 2, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).generationAttempts(128)).create());
        this.addGenerator("emeralds", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
    }
}

