/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.common.command.BOPCommand;
import biomesoplenty.common.entities.EntityPixie;
import biomesoplenty.common.entities.EntityWasp;
import biomesoplenty.common.entities.projectiles.EntityMudball;
import biomesoplenty.core.BiomesOPlenty;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class ModEntities {
    private static int nextBOPEntityId = 1;

    public static void init() {
        ModEntities.registerBOPEntity(EntityMudball.class, "mudball", 64, 10, true);
        ModEntities.registerBOPEntityWithSpawnEgg(EntityWasp.class, "wasp", 80, 3, true, 15052819, 0x333234);
        ModEntities.registerBOPEntityWithSpawnEgg(EntityPixie.class, "pixie", 80, 3, true, 0xFF99E9, 0xFFFFFF);
    }

    public static int registerBOPEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        int bopEntityId = nextBOPEntityId++;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("biomesoplenty", entityName), entityClass, (String)entityName, (int)bopEntityId, (Object)BiomesOPlenty.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++BOPCommand.entityCount;
        return bopEntityId;
    }

    public static int registerBOPEntityWithSpawnEgg(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggBackgroundColor, int eggForegroundColor) {
        int bopEntityId = ModEntities.registerBOPEntity(entityClass, entityName, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("biomesoplenty", entityName), (int)eggBackgroundColor, (int)eggForegroundColor);
        return bopEntityId;
    }

    public static Entity createEntityByID(int bopEntityId, World worldIn) {
        Entity entity = null;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)BiomesOPlenty.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, bopEntityId);
        if (er != null) {
            Class clazz = er.getEntityClass();
            try {
                if (clazz != null) {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            BiomesOPlenty.logger.warn("Skipping BOP Entity with id " + bopEntityId);
        }
        return entity;
    }
}

