/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.generation.BOPGenLayer;
import biomesoplenty.common.init.ModBiomes;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerSubBiomesBOP
extends BOPGenLayer {
    private GenLayer subBiomesInit;

    public GenLayerSubBiomesBOP(long seed, GenLayer biomesLayer, GenLayer subBiomesInit) {
        super(seed);
        this.field_75909_a = biomesLayer;
        this.subBiomesInit = subBiomesInit;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] biomeIds = this.field_75909_a.func_75904_a(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] initVals = this.subBiomesInit.func_75904_a(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int z = 0; z < areaHeight; ++z) {
            for (int x = 0; x < areaWidth; ++x) {
                boolean tryRareHillsBiome;
                this.func_75903_a(x + areaX, z + areaY);
                int biomeID = biomeIds[x + 1 + (z + 1) * (areaWidth + 2)];
                int initVal = initVals[x + 1 + (z + 1) * (areaWidth + 2)] % 29;
                boolean tryRareBiome = initVal == 1;
                boolean bl = tryRareHillsBiome = initVal == 2;
                if (biomeID != 0 && tryRareBiome) {
                    out[x + z * areaWidth] = this.getRareSubBiome(biomeID);
                    continue;
                }
                if (this.func_75902_a(3) != 0 && !tryRareHillsBiome) {
                    out[x + z * areaWidth] = biomeID;
                    continue;
                }
                int altBiomeID = this.getCommonSubBiome(biomeID);
                if (altBiomeID == biomeID) {
                    out[x + z * areaWidth] = biomeID;
                    continue;
                }
                if (tryRareHillsBiome) {
                    altBiomeID = this.getRareSubBiome(altBiomeID);
                }
                int biomeNorth = biomeIds[x + 1 + (z + 1 - 1) * (areaWidth + 2)];
                int biomeEast = biomeIds[x + 1 + 1 + (z + 1) * (areaWidth + 2)];
                int biomeWest = biomeIds[x + 1 - 1 + (z + 1) * (areaWidth + 2)];
                int biomeSouth = biomeIds[x + 1 + (z + 1 + 1) * (areaWidth + 2)];
                int surroundingSameCount = 0;
                if (GenLayerSubBiomesBOP.func_151616_a((int)biomeNorth, (int)biomeID)) {
                    ++surroundingSameCount;
                }
                if (GenLayerSubBiomesBOP.func_151616_a((int)biomeEast, (int)biomeID)) {
                    ++surroundingSameCount;
                }
                if (GenLayerSubBiomesBOP.func_151616_a((int)biomeWest, (int)biomeID)) {
                    ++surroundingSameCount;
                }
                if (GenLayerSubBiomesBOP.func_151616_a((int)biomeSouth, (int)biomeID)) {
                    ++surroundingSameCount;
                }
                out[x + z * areaWidth] = surroundingSameCount >= 3 ? altBiomeID : biomeID;
            }
        }
        return out;
    }

    public int getRareSubBiome(int biomeId) {
        int subBiomeId = Biome.func_185362_a((Biome)Biome.func_185356_b((Biome)Biome.func_150568_d((int)biomeId)));
        return subBiomeId == -1 ? biomeId : subBiomeId;
    }

    public int getCommonSubBiome(int biomeId) {
        List<Integer> subBiomeIds = ModBiomes.subBiomesMap.get(biomeId);
        if (subBiomeIds == null) {
            return biomeId;
        }
        int n = subBiomeIds.size();
        return n == 0 ? biomeId : (n == 1 ? subBiomeIds.get(0).intValue() : subBiomeIds.get(this.func_75902_a(n)).intValue());
    }
}

