/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks.growables;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import com.pam.harvestcraft.blocks.growables.PamCropGrowable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.FMLLog;

public class BlockPamFruitLog
extends Block
implements IGrowable,
PamCropGrowable,
IShearable {
    private static final int MATURE_AGE = 2;
    private final BlockPamSapling sapling;
    private final Item fruitItem;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    private String BASE_STAGE_ID = null;

    public BlockPamFruitLog(BlockPamSapling sapling, Item fruit) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(HarvestCraft.modTab);
        this.func_149672_a(SoundType.field_185848_a);
        this.sapling = sapling;
        this.fruitItem = fruit;
    }

    @Override
    public PropertyInteger getAgeProperty() {
        return AGE;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public Item getFruitItem() {
        if (this.fruitItem == null) {
            FMLLog.bigWarning((String)"Cannot get fruit %s.", (Object[])new Object[]{this.func_149739_a()});
        }
        return this.fruitItem;
    }

    public BlockPamSapling getSapling() {
        return this.sapling;
    }

    public String getStageId(int stage) {
        if (this.BASE_STAGE_ID == null) {
            this.BASE_STAGE_ID = this.func_149739_a().replaceFirst("pam", "").replaceFirst("tile.", "").toLowerCase() + "_stage";
        }
        return this.BASE_STAGE_ID + stage;
    }

    @Override
    public int getMatureAge() {
        return 2;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return this.func_176201_c(state) >= this.getMatureAge();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.isMature(state)) {
            return this.getFruitItem();
        }
        return null;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 2 && rand.nextInt(25) == 0) {
            state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1));
            worldIn.func_180501_a(pos, state, 2);
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    private void grow(World worldIn, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
        if (i > 2) {
            i = 2;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.func_176201_c(state) >= 2) {
            drops.add(new ItemStack(this.getFruitItem(), 1));
            drops.add(new ItemStack(this.getFruitItem(), 1));
        }
        return drops;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMature(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }
}

