/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FruitTreeWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        if (random.nextFloat() > 0.12f) {
            return;
        }
        int x = chunkX * 16 + 8 + random.nextInt(16);
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 64, z = chunkZ * 16 + 8 + random.nextInt(16)));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            switch (random.nextInt(9)) {
                case 0: {
                    if (HarvestCraft.config.appletreeGeneration) {
                        this.generateFruitTree(world, random, "apple", x, z);
                        return;
                    }
                }
                case 1: {
                    if (HarvestCraft.config.avocadotreeGeneration) {
                        this.generateFruitTree(world, random, "avocado", x, z);
                        return;
                    }
                }
                case 2: {
                    if (HarvestCraft.config.cherrytreeGeneration) {
                        this.generateFruitTree(world, random, "cherry", x, z);
                        return;
                    }
                }
                case 3: {
                    if (HarvestCraft.config.chestnuttreeGeneration) {
                        this.generateFruitTree(world, random, "chestnut", x, z);
                        return;
                    }
                }
                case 4: {
                    if (HarvestCraft.config.nutmegtreeGeneration) {
                        this.generateFruitTree(world, random, "nutmeg", x, z);
                        return;
                    }
                }
                case 5: {
                    if (HarvestCraft.config.peartreeGeneration) {
                        this.generateFruitTree(world, random, "pear", x, z);
                        return;
                    }
                }
                case 6: {
                    if (HarvestCraft.config.plumtreeGeneration) {
                        this.generateFruitTree(world, random, "plum", x, z);
                        return;
                    }
                }
                case 7: {
                    if (HarvestCraft.config.walnuttreeGeneration) {
                        this.generateFruitTree(world, random, "walnut", x, z);
                        return;
                    }
                }
                case 8: {
                    if (!HarvestCraft.config.gooseberrytreeGeneration) break;
                    this.generateFruitTree(world, random, "gooseberry", x, z);
                    return;
                }
            }
        }
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET))) {
            switch (random.nextInt(25)) {
                case 0: {
                    if (HarvestCraft.config.bananatreeGeneration) {
                        this.generateFruitTree(world, random, "banana", x, z);
                        return;
                    }
                }
                case 1: {
                    if (HarvestCraft.config.cinnamontreeGeneration) {
                        this.generateFruitTree(world, random, "cinnamon", x, z);
                        return;
                    }
                }
                case 2: {
                    if (HarvestCraft.config.coconuttreeGeneration) {
                        this.generateFruitTree(world, random, "coconut", x, z);
                        return;
                    }
                }
                case 3: {
                    if (HarvestCraft.config.datetreeGeneration) {
                        this.generateFruitTree(world, random, "date", x, z);
                        return;
                    }
                }
                case 4: {
                    if (HarvestCraft.config.dragonfruittreeGeneration) {
                        this.generateFruitTree(world, random, "dragonfruit", x, z);
                        return;
                    }
                }
                case 5: {
                    if (HarvestCraft.config.papayatreeGeneration) {
                        this.generateFruitTree(world, random, "papaya", x, z);
                        return;
                    }
                }
                case 6: {
                    if (HarvestCraft.config.almondtreeGeneration) {
                        this.generateFruitTree(world, random, "almond", x, z);
                        return;
                    }
                }
                case 7: {
                    if (HarvestCraft.config.apricottreeGeneration) {
                        this.generateFruitTree(world, random, "apricot", x, z);
                        return;
                    }
                }
                case 8: {
                    if (HarvestCraft.config.cashewtreeGeneration) {
                        this.generateFruitTree(world, random, "cashew", x, z);
                        return;
                    }
                }
                case 9: {
                    if (HarvestCraft.config.duriantreeGeneration) {
                        this.generateFruitTree(world, random, "durian", x, z);
                        return;
                    }
                }
                case 10: {
                    if (HarvestCraft.config.figtreeGeneration) {
                        this.generateFruitTree(world, random, "fig", x, z);
                        return;
                    }
                }
                case 11: {
                    if (HarvestCraft.config.grapefruittreeGeneration) {
                        this.generateFruitTree(world, random, "grapefruit", x, z);
                        return;
                    }
                }
                case 12: {
                    if (HarvestCraft.config.lemontreeGeneration) {
                        this.generateFruitTree(world, random, "lemon", x, z);
                        return;
                    }
                }
                case 13: {
                    if (HarvestCraft.config.limetreeGeneration) {
                        this.generateFruitTree(world, random, "lime", x, z);
                        return;
                    }
                }
                case 14: {
                    if (HarvestCraft.config.mangotreeGeneration) {
                        this.generateFruitTree(world, random, "mango", x, z);
                        return;
                    }
                }
                case 15: {
                    if (HarvestCraft.config.orangetreeGeneration) {
                        this.generateFruitTree(world, random, "orange", x, z);
                        return;
                    }
                }
                case 16: {
                    if (HarvestCraft.config.paperbarktreeGeneration) {
                        this.generateFruitTree(world, random, "paperbark", x, z);
                        return;
                    }
                }
                case 17: {
                    if (HarvestCraft.config.peachtreeGeneration) {
                        this.generateFruitTree(world, random, "peach", x, z);
                        return;
                    }
                }
                case 18: {
                    if (HarvestCraft.config.pecantreeGeneration) {
                        this.generateFruitTree(world, random, "pecan", x, z);
                        return;
                    }
                }
                case 19: {
                    if (HarvestCraft.config.peppercorntreeGeneration) {
                        this.generateFruitTree(world, random, "peppercorn", x, z);
                        return;
                    }
                }
                case 20: {
                    if (HarvestCraft.config.persimmontreeGeneration) {
                        this.generateFruitTree(world, random, "persimmon", x, z);
                        return;
                    }
                }
                case 21: {
                    if (HarvestCraft.config.pistachiotreeGeneration) {
                        this.generateFruitTree(world, random, "pistachio", x, z);
                        return;
                    }
                }
                case 22: {
                    if (HarvestCraft.config.pomegranatetreeGeneration) {
                        this.generateFruitTree(world, random, "pomegranate", x, z);
                        return;
                    }
                }
                case 23: {
                    if (HarvestCraft.config.starfruittreeGeneration) {
                        this.generateFruitTree(world, random, "starfruit", x, z);
                        return;
                    }
                }
                case 24: {
                    if (HarvestCraft.config.vanillabeantreeGeneration) {
                        this.generateFruitTree(world, random, "vanillabean", x, z);
                        return;
                    }
                }
                case 25: {
                    if (!HarvestCraft.config.olivetreeGeneration) break;
                    this.generateFruitTree(world, random, "olive", x, z);
                    return;
                }
            }
        }
        if ((BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) && HarvestCraft.config.mapletreeGeneration) {
            this.generateFruitTree(world, random, "maple", x, z);
            return;
        }
    }

    private void generateFruitTree(World world, Random random, String fruitName, int x, int z) {
        BlockPamSapling sapling = FruitRegistry.getSapling(fruitName);
        if (sapling != null) {
            sapling.worldGenTree(world, random, x, z);
        }
    }
}

