/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sonar.core.SonarCore;
import sonar.core.common.block.BlockBase;
import sonar.core.common.block.ConnectedBlock;
import sonar.core.common.block.SonarBlockTip;
import sonar.core.common.block.SonarFence;
import sonar.core.common.block.SonarGate;
import sonar.core.common.block.SonarMetaBlock;
import sonar.core.common.block.SonarStairs;
import sonar.core.common.block.StableStone;

public class SonarBlocks
extends SonarCore {
    public static ArrayList<Block> registeredBlocks = new ArrayList();

    public static Block registerBlock(String name, Block block) {
        block.func_149647_a(tab);
        block.func_149663_c(name);
        block.setRegistryName("sonarcore", name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register(new SonarBlockTip(block).setRegistryName("sonarcore", name));
        registeredBlocks.add(block);
        return block;
    }

    public static Block registerMetaBlock(String name, Block block) {
        block.func_149647_a(tab);
        block.func_149663_c(name);
        block.setRegistryName("sonarcore", name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register(new SonarMetaBlock(block).setRegistryName("sonarcore", name));
        registeredBlocks.add(block);
        return block;
    }

    public static void registerSlab(String name, Item slab, BlockSlab singleSlab, BlockSlab doubleSlab) {
    }

    public static void registerBlocks() {
        reinforcedStoneBlock = SonarBlocks.registerBlock("ReinforcedStoneBlock", new BlockBase(Material.field_151576_e, 2.0f, 50.0f));
        reinforcedStoneStairs = SonarBlocks.registerBlock("ReinforcedStoneStairs", (Block)new SonarStairs(reinforcedStoneBlock));
        reinforcedStoneFence = SonarBlocks.registerBlock("ReinforcedStoneFence", (Block)new SonarFence(Material.field_151576_e));
        reinforcedStoneGate = SonarBlocks.registerBlock("ReinforcedStoneGate", (Block)new SonarGate(reinforcedStoneBlock));
        reinforcedStoneBrick = SonarBlocks.registerBlock("ReinforcedStoneBrick", new BlockBase(Material.field_151576_e, 2.0f, 50.0f));
        reinforcedStoneBrickStairs = SonarBlocks.registerBlock("ReinforcedStoneBrickStairs", (Block)new SonarStairs(reinforcedStoneBrick));
        reinforcedStoneBrickFence = SonarBlocks.registerBlock("ReinforcedStoneBrickFence", (Block)new SonarFence(Material.field_151576_e));
        reinforcedStoneBrickGate = SonarBlocks.registerBlock("ReinforcedStoneBrickGate", (Block)new SonarGate(reinforcedStoneBrick));
        reinforcedDirtBlock = SonarBlocks.registerBlock("ReinforcedDirtBlock", new BlockBase(Material.field_151578_c, 1.0f, 20.0f));
        reinforcedDirtStairs = SonarBlocks.registerBlock("ReinforcedDirtStairs", (Block)new SonarStairs(reinforcedDirtBlock));
        reinforcedDirtFence = SonarBlocks.registerBlock("ReinforcedDirtFence", (Block)new SonarFence(Material.field_151578_c));
        reinforcedDirtGate = SonarBlocks.registerBlock("ReinforcedDirtGate", (Block)new SonarGate(reinforcedDirtBlock));
        reinforcedDirtBrick = SonarBlocks.registerBlock("ReinforcedDirtBrick", new BlockBase(Material.field_151578_c, 1.0f, 20.0f));
        reinforcedDirtBrickStairs = SonarBlocks.registerBlock("ReinforcedDirtBrickStairs", (Block)new SonarStairs(reinforcedDirtBrick));
        reinforcedDirtBrickFence = SonarBlocks.registerBlock("ReinforcedDirtBrickFence", (Block)new SonarFence(Material.field_151578_c));
        reinforcedDirtBrickGate = SonarBlocks.registerBlock("ReinforcedDirtBrickGate", (Block)new SonarGate(reinforcedDirtBrick));
        int pos = 0;
        for (StableStone.Variants variant : StableStone.Variants.values()) {
            Block normal = SonarBlocks.registerBlock("StableStone_" + variant.name(), new StableStone(Material.field_151576_e, 100 + pos).func_149711_c(2.0f));
            Block rimmed = SonarBlocks.registerBlock("StableStoneRimmed_" + variant.name(), new StableStone(Material.field_151576_e, 200 + pos).func_149711_c(2.0f));
            Block black = SonarBlocks.registerBlock("StableStoneBlackRimmed_" + variant.name(), new StableStone(Material.field_151576_e, 300 + pos).func_149711_c(2.0f));
            SonarBlocks.stableStone[pos] = normal;
            SonarBlocks.stablestonerimmedBlock[pos] = rimmed;
            SonarBlocks.stablestonerimmedblackBlock[pos] = black;
            ++pos;
        }
        stableGlass = SonarBlocks.registerBlock("StableGlass", new ConnectedBlock.Glass(Material.field_151592_s, 1)).func_149715_a(0.625f).func_149711_c(0.6f);
        clearStableGlass = SonarBlocks.registerBlock("ClearStableGlass", new ConnectedBlock.Glass(Material.field_151592_s, 2)).func_149715_a(0.625f).func_149711_c(0.6f);
    }
}

