/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class GuiBlockRenderer3D
implements IBlockAccess {
    protected static final Minecraft mc = Minecraft.func_71410_x();
    public final Vector3d origin = new Vector3d();
    public final Vector3d eye = new Vector3d();
    public HashMap<BlockPos, IBlockState> blocks = new HashMap();
    public HashMap<BlockPos, TileEntity> entities = new HashMap();
    public int cubeSize;

    public GuiBlockRenderer3D(int cubeSize) {
        this.cubeSize = cubeSize;
    }

    public boolean validPos(BlockPos pos) {
        int size = this.cubeSize / 2;
        return pos.func_177958_n() < size && pos.func_177958_n() > -size && pos.func_177956_o() < size && pos.func_177956_o() > -size && pos.func_177952_p() < size && pos.func_177952_p() > -size;
    }

    public void addBlock(IBlockState state, BlockPos pos) {
        if (this.validPos(pos)) {
            this.blocks.put(pos, state);
        }
    }

    public void addTileEntity(TileEntity state, BlockPos pos) {
        if (this.validPos(pos)) {
            this.entities.put(pos, state);
        }
    }

    public void renderInGui() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        GuiBlockRenderer3D.mc.field_71460_t.func_175072_h();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        Vector3d trans = new Vector3d(-this.origin.x + this.eye.x - 0.5, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z - 0.5);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            this.setGlStateForPass(layer);
            this.doWorldRenderPass(trans, layer);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = this.origin.z - this.eye.z;
        TileEntityRendererDispatcher.field_147554_b = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147555_c = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147552_d = this.origin.z - this.eye.z;
        for (int pass = 0; pass < 2; ++pass) {
            this.setGlStateForPass(pass);
            this.doTileEntityRenderPass(pass);
        }
        this.setGlStateForPass(0);
    }

    private void doTileEntityRenderPass(int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        for (Map.Entry<BlockPos, TileEntity> entry : this.entities.entrySet()) {
            TileEntity tile = this.func_175625_s(entry.getKey());
            if (tile == null || !tile.shouldRenderInPass(pass)) continue;
            Vector3d at = new Vector3d(this.eye.x, this.eye.y, this.eye.z);
            BlockPos pos = entry.getKey();
            at.x += (double)pos.func_177958_n() - this.origin.x;
            at.y += (double)pos.func_177956_o() - this.origin.y;
            at.z += (double)pos.func_177952_p() - this.origin.z;
            if (tile.getClass() == TileEntityChest.class) {
                TileEntityChest chest = (TileEntityChest)tile;
                at.x -= 0.5;
                at.z -= 0.5;
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            }
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, at.x, at.y, at.z, 0.0f);
            if (tile.getClass() != TileEntityChest.class) continue;
            GL11.glRotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
        }
    }

    private void doWorldRenderPass(Vector3d trans, BlockRenderLayer layer) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Tessellator.func_178181_a().func_178180_c().func_178969_c(trans.x, trans.y, trans.z);
        for (Map.Entry<BlockPos, IBlockState> entry : this.blocks.entrySet()) {
            IBlockState state = entry.getValue();
            BlockPos pos = entry.getKey();
            Block block = state.func_177230_c();
            if (!block.canRenderInLayer(state = state.func_185899_b((IBlockAccess)this, pos), layer)) continue;
            this.renderBlock(state, entry.getKey(), this, Tessellator.func_178181_a().func_178180_c());
        }
        Tessellator.func_178181_a().func_78381_a();
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
    }

    public void renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRendererIn) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
            EnumBlockRenderType type = state.func_185901_i();
            if (type != EnumBlockRenderType.MODEL) {
                blockrendererdispatcher.func_175018_a(state, pos, blockAccess, worldRendererIn);
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this, pos);
            blockrendererdispatcher.func_175019_b().func_178267_a(blockAccess, ibakedmodel, state, pos, worldRendererIn, false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void renderMultipart(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRendererIn) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
            EnumBlockRenderType type = state.func_185901_i();
            if (type != EnumBlockRenderType.MODEL) {
                blockrendererdispatcher.func_175018_a(state, pos, blockAccess, worldRendererIn);
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            blockrendererdispatcher.func_175019_b().func_178267_a(blockAccess, ibakedmodel, state, pos, worldRendererIn, false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void setGlStateForPass(BlockRenderLayer layer) {
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        this.setGlStateForPass(pass);
    }

    private void setGlStateForPass(int layer) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.entities.get(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return 0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState state = this.blocks.get(pos);
        return state == null ? Blocks.field_150350_a.func_176223_P() : state;
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.blocks.get(pos) == null;
    }

    public Biome func_180494_b(BlockPos pos) {
        return Biome.func_150568_d((int)0);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return false;
    }
}

