/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import sonar.core.api.SonarAPI;
import sonar.core.api.StorageSize;
import sonar.core.api.asm.InventoryHandler;
import sonar.core.api.inventories.ISonarInventoryHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;

@InventoryHandler(modid="sonarcore", priority=3)
public class DSUInventoryHandler
implements ISonarInventoryHandler {
    @Override
    public boolean canHandleItems(TileEntity tile, EnumFacing dir) {
        return tile instanceof IDeepStorageUnit;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, EnumFacing dir) {
        IDeepStorageUnit inv;
        if (slot <= 0 && (inv = (IDeepStorageUnit)tile).getStoredItemType() != null) {
            return new StoredItemStack(inv.getStoredItemType());
        }
        return null;
    }

    @Override
    public StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, EnumFacing dir) {
        IDeepStorageUnit inv = (IDeepStorageUnit)tile;
        if (inv.getStoredItemType() != null) {
            StoredItemStack stack = new StoredItemStack(inv.getStoredItemType());
            if (stack.stored != 0L) {
                SonarAPI.getItemHelper().addStackToList(storedStacks, stack);
                return new StorageSize(stack.stored, inv.getMaxStoredCount());
            }
        }
        return new StorageSize(0L, inv.getMaxStoredCount());
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, EnumFacing dir, ActionType action) {
        IDeepStorageUnit inv = (IDeepStorageUnit)tile;
        ItemStack stack = inv.getStoredItemType();
        if (!stack.func_190926_b()) {
            if (add.equalStack(stack)) {
                long storedItems;
                long max = inv.getMaxStoredCount();
                if (max == (storedItems = (long)stack.func_190916_E())) {
                    return add;
                }
                if ((storedItems += add.getStackSize()) > max) {
                    long remove = storedItems - max;
                    if (!action.shouldSimulate()) {
                        inv.setStoredItemCount((int)max);
                    }
                    return new StoredItemStack(add.getItemStack(), remove);
                }
                if (!action.shouldSimulate()) {
                    inv.setStoredItemCount(stack.func_190916_E() + (int)add.getStackSize());
                }
                return null;
            }
        } else {
            long max = inv.getMaxStoredCount();
            if (!action.shouldSimulate()) {
                inv.setStoredItemType(add.getItemStack(), (int)add.getStackSize());
            }
            return null;
        }
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, EnumFacing dir, ActionType action) {
        IDeepStorageUnit inv = (IDeepStorageUnit)tile;
        ItemStack stack = inv.getStoredItemType();
        if (remove.equalStack(stack)) {
            if (remove.getStackSize() >= (long)stack.func_190916_E()) {
                stack = stack.func_77946_l();
                remove.stored -= (long)stack.func_190916_E();
                if (!action.shouldSimulate()) {
                    inv.setStoredItemCount(0);
                }
                return remove;
            }
            if (!action.shouldSimulate()) {
                inv.setStoredItemCount(stack.func_190916_E() - (int)remove.getStackSize());
            }
            return null;
        }
        return remove;
    }

    @Override
    public boolean isLargeInventory() {
        return false;
    }
}

