/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.api.SonarAPI;
import sonar.core.api.StorageSize;
import sonar.core.api.asm.InventoryHandler;
import sonar.core.api.inventories.ISonarInventoryHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;

@InventoryHandler(modid="StorageDrawers", priority=2)
public class DrawersInventoryHandler
implements ISonarInventoryHandler {
    @Override
    public boolean canHandleItems(TileEntity tile, EnumFacing dir) {
        return tile instanceof IDrawerGroup;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, EnumFacing dir) {
        IDrawerGroup drawers;
        if (tile instanceof IDrawerGroup && slot < (drawers = (IDrawerGroup)tile).getDrawerCount()) {
            IDrawer draw = drawers.getDrawer(slot);
            ItemStack item = draw.getStoredItemPrototype();
            if (item != null) {
                return new StoredItemStack(item);
            }
            return null;
        }
        return null;
    }

    @Override
    public StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, EnumFacing dir) {
        if (tile instanceof IDrawerGroup) {
            IDrawerGroup drawers = (IDrawerGroup)tile;
            long maxStorage = 0L;
            long stored = 0L;
            for (int i = 0; i < drawers.getDrawerCount(); ++i) {
                if (drawers.getDrawer(i) == null) continue;
                IDrawer draw = drawers.getDrawer(i);
                ItemStack item = draw.getStoredItemPrototype();
                maxStorage += (long)draw.getMaxCapacity();
                stored += (long)draw.getStoredItemCount();
                if (item.func_190926_b()) continue;
                SonarAPI.getItemHelper().addStackToList(storedStacks, new StoredItemStack(item, draw.getStoredItemCount()));
            }
            return new StorageSize(stored, maxStorage);
        }
        return StorageSize.EMPTY;
    }

    private long injectItemsIntoDrawer(IDrawer drawer, long itemCount) {
        return itemCount;
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, EnumFacing dir, ActionType action) {
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, EnumFacing dir, ActionType action) {
        return remove;
    }

    @Override
    public boolean isLargeInventory() {
        return false;
    }
}

