/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sonar.core.SonarCore;
import sonar.core.api.StorageSize;
import sonar.core.api.inventories.ISonarInventoryHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.api.wrappers.InventoryWrapper;
import sonar.core.handlers.inventories.IInventoryHandler;

public class InventoryHelper
extends InventoryWrapper {
    public static ISonarInventoryHandler defHandler = new IInventoryHandler();

    public static boolean addStack(IInventory inv, StoredItemStack add, int slot, int limit, ActionType action) {
        if (inv.func_94041_b(slot, add.item)) {
            ItemStack stored = inv.func_70301_a(slot);
            if (!stored.func_190926_b()) {
                long used;
                ItemStack stack = stored.func_77946_l();
                if (add.equalStack(stack) && stack.func_190916_E() < limit && stack.func_190916_E() < stack.func_77976_d() && (used = Math.min((long)(add.item.func_77976_d() - stack.func_190916_E()), Math.min(add.stored, (long)(limit - stack.func_190916_E())))) > 0L) {
                    stack.func_190920_e((int)((long)stack.func_190916_E() + used));
                    add.stored -= used;
                    if (!action.shouldSimulate()) {
                        inv.func_70299_a(slot, stack.func_77946_l());
                        inv.func_70296_d();
                    }
                }
            } else {
                long used = Math.min((long)add.item.func_77976_d(), Math.min(add.stored, (long)limit));
                if (used > 0L) {
                    ItemStack stack = new StoredItemStack(add.getFullStack()).setStackSize(used).getFullStack();
                    add.stored -= used;
                    if (!action.shouldSimulate()) {
                        inv.func_70299_a(slot, stack);
                        inv.func_70296_d();
                    }
                }
            }
            if (add.stored == 0L) {
                return false;
            }
        }
        return true;
    }

    public static boolean removeStack(IInventory inv, StoredItemStack remove, ItemStack stored, int slot, ActionType action) {
        ItemStack stack = stored.func_77946_l();
        if (remove.equalStack(stack)) {
            long used = Math.min(remove.stored, (long)Math.min(inv.func_70297_j_(), stack.func_190916_E()));
            stack.func_190920_e((int)((long)stack.func_190916_E() - used));
            remove.stored -= used;
            if (stack.func_190916_E() == 0) {
                stack = ItemStack.field_190927_a;
            }
            if (!action.shouldSimulate()) {
                inv.func_70299_a(slot, stack);
                inv.func_70296_d();
            }
            if (remove.stored == 0L) {
                return false;
            }
        }
        return true;
    }

    @Override
    public StoredItemStack getStackToAdd(long inputSize, StoredItemStack stack, StoredItemStack returned) {
        StoredItemStack simulateStack = null;
        simulateStack = returned == null || returned.stored == 0L ? new StoredItemStack(stack.getItemStack(), inputSize) : new StoredItemStack(stack.getItemStack(), inputSize - returned.stored);
        return simulateStack;
    }

    @Override
    public StorageSize addInventoryToList(List<StoredItemStack> list, IInventory inv) {
        long stored = 0L;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stored += (long)stack.func_190916_E();
            this.addStackToList(list, inv.func_70301_a(i));
        }
        int max = inv.func_70297_j_() * inv.func_70302_i_();
        return new StorageSize(stored, max);
    }

    @Override
    public StorageSize addItemHandlerToList(List<StoredItemStack> list, IItemHandler inv) {
        long stored = 0L;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stored += (long)stack.func_190916_E();
            this.addStackToList(list, stack);
        }
        return new StorageSize(stored, inv.getSlots() * 64);
    }

    private void addStackToList(List<StoredItemStack> list, ItemStack stack) {
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(new StoredItemStack(stack));
    }

    @Override
    public void addStackToList(List<StoredItemStack> list, StoredItemStack stack) {
        if (stack == null || list == null) {
            return;
        }
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack.item)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(stack);
    }

    @Override
    public void spawnStoredItemStack(StoredItemStack drop, World world, int x, int y, int z, EnumFacing side) {
        ArrayList<EntityItem> drops = new ArrayList<EntityItem>();
        while (drop.stored > 0L) {
            ItemStack dropStack = drop.getItemStack();
            dropStack.func_190920_e((int)Math.min(drop.stored, (long)dropStack.func_77976_d()));
            drop.stored -= (long)dropStack.func_190916_E();
            drops.add(new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, dropStack));
        }
        if (drop.stored < 0L) {
            SonarCore.logger.error("ERROR: Excess Items in Drop");
        }
        for (EntityItem item : drops) {
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            if (side == EnumFacing.NORTH) {
                item.field_70179_y = -0.1;
            }
            if (side == EnumFacing.SOUTH) {
                item.field_70179_y = 0.1;
            }
            if (side == EnumFacing.WEST) {
                item.field_70159_w = -0.1;
            }
            if (side == EnumFacing.EAST) {
                item.field_70159_w = 0.1;
            }
            world.func_72838_d((Entity)item);
        }
    }

    public ItemStack addItems(TileEntity tile, StoredItemStack stack, ActionType type) {
        if (stack == null || tile == null) {
            return ItemStack.field_190927_a;
        }
        StoredItemStack returned = defHandler.addStack(stack.copy(), tile, null, type);
        StoredItemStack add = this.getStackToAdd(stack.getStackSize(), stack.copy(), returned);
        return add.getActualStack();
    }

    public ItemStack removeItems(TileEntity tile, StoredItemStack stack, ActionType type) {
        if (stack == null || tile == null) {
            return ItemStack.field_190927_a;
        }
        StoredItemStack returned = defHandler.removeStack(stack.copy(), tile, null, type);
        StoredItemStack add = this.getStackToAdd(stack.getStackSize(), stack.copy(), returned);
        return add.getActualStack();
    }

    @Override
    public StoredItemStack addItems(TileEntity tile, StoredItemStack stack, EnumFacing dir, ActionType type, IInventoryFilter filter) {
        long maxAdd = InventoryHelper.maxAdd(filter, stack.getStackSize());
        if (maxAdd == 0L) {
            return null;
        }
        if (tile != null && (filter == null || filter.allowed(stack.getFullStack()))) {
            List<ISonarInventoryHandler> handlers = SonarCore.inventoryHandlers;
            for (ISonarInventoryHandler handler : handlers) {
                if (!handler.canHandleItems(tile, dir)) continue;
                StoredItemStack returned = handler.addStack(stack.copy().setStackSize(maxAdd), tile, dir, type);
                StoredItemStack add = this.getStackToAdd(maxAdd, stack.copy(), returned);
                InventoryHelper.onAdd(filter, add.getStackSize());
                return add;
            }
        }
        return null;
    }

    @Override
    public StoredItemStack removeItems(TileEntity tile, StoredItemStack stack, EnumFacing dir, ActionType type, IInventoryFilter filter) {
        long maxRemove = InventoryHelper.maxRemove(filter, stack.getStackSize());
        if (maxRemove == 0L) {
            return null;
        }
        if (tile != null && (filter == null || filter.allowed(stack.getFullStack()))) {
            List<ISonarInventoryHandler> handlers = SonarCore.inventoryHandlers;
            for (ISonarInventoryHandler handler : handlers) {
                if (!handler.canHandleItems(tile, dir)) continue;
                StoredItemStack returned = handler.removeStack(stack.copy().setStackSize(maxRemove), tile, dir, type);
                StoredItemStack remove = this.getStackToAdd(maxRemove, stack.copy(), returned);
                InventoryHelper.onRemove(filter, remove.getStackSize());
                return remove;
            }
        }
        return null;
    }

    @Override
    public void transferItems(TileEntity from, TileEntity to, EnumFacing dirFrom, EnumFacing dirTo, IInventoryFilter filter) {
        if (from != null && to != null) {
            ArrayList<StoredItemStack> stacks = new ArrayList<StoredItemStack>();
            List<ISonarInventoryHandler> handlers = SonarCore.inventoryHandlers;
            for (ISonarInventoryHandler handler : handlers) {
                if (!handler.canHandleItems(from, dirFrom)) continue;
                handler.getItems(stacks, from, dirFrom);
                break;
            }
            if (stacks.isEmpty()) {
                return;
            }
            for (StoredItemStack stack : stacks) {
                StoredItemStack add;
                StoredItemStack removed = this.removeItems(from, stack.copy(), dirFrom, ActionType.SIMULATE, InventoryHelper.copy(filter));
                if (removed == null || (add = this.addItems(to, removed.copy(), dirTo, ActionType.SIMULATE, InventoryHelper.copy(filter))) == null) continue;
                this.removeItems(from, add.copy(), dirFrom, ActionType.PERFORM, filter);
                this.addItems(to, removed.copy(), dirTo, ActionType.PERFORM, filter);
            }
        }
    }

    public static IInventoryFilter copy(IInventoryFilter filter) {
        if (filter == null || !(filter instanceof ITransferOverride)) {
            return null;
        }
        return ((ITransferOverride)filter).copy();
    }

    public static void reset(IInventoryFilter filter) {
        if (filter == null || !(filter instanceof ITransferOverride)) {
            return;
        }
        ((ITransferOverride)filter).reset();
    }

    public static long maxAdd(IInventoryFilter filter, long l) {
        if (filter == null || !(filter instanceof ITransferOverride)) {
            return l;
        }
        return Math.min(((ITransferOverride)filter).getMaxAdd(), l);
    }

    public static void onAdd(IInventoryFilter filter, long added) {
        if (filter == null || !(filter instanceof ITransferOverride)) {
            return;
        }
        ((ITransferOverride)filter).add(added);
    }

    public static long maxRemove(IInventoryFilter filter, long maxRemove) {
        if (filter == null || !(filter instanceof ITransferOverride)) {
            return maxRemove;
        }
        return Math.min(((ITransferOverride)filter).getMaxRemove(), maxRemove);
    }

    public static void onRemove(IInventoryFilter filter, long removed) {
        if (filter == null || !(filter instanceof ITransferOverride)) {
            return;
        }
        ((ITransferOverride)filter).remove(removed);
    }

    public static interface IInventoryFilter {
        public boolean allowed(ItemStack var1);
    }

    public static interface ITransferOverride
    extends IInventoryFilter {
        public ITransferOverride copy();

        public void reset();

        public void add(long var1);

        public void remove(long var1);

        public long getMaxRemove();

        public long getMaxAdd();
    }

    public static class DefaultTransferOverride
    implements ITransferOverride {
        public long maxAdd;
        public long maxRemove;
        public long currentAdd;
        public long currentRemove;

        public DefaultTransferOverride(long max) {
            this.maxAdd = max;
            this.currentAdd = max;
            this.maxRemove = max;
            this.currentRemove = max;
        }

        public DefaultTransferOverride(long maxAdd, long maxRemove) {
            this.maxAdd = maxAdd;
            this.currentAdd = maxAdd;
            this.maxRemove = maxRemove;
            this.currentRemove = maxRemove;
        }

        public boolean canTransfer() {
            return this.currentAdd != 0L || this.currentRemove != 0L;
        }

        @Override
        public ITransferOverride copy() {
            return new DefaultTransferOverride(this.maxAdd, this.maxRemove);
        }

        @Override
        public boolean allowed(ItemStack stack) {
            return true;
        }

        @Override
        public void reset() {
            this.currentAdd = this.maxAdd;
            this.currentRemove = this.maxRemove;
        }

        @Override
        public void add(long added) {
            this.currentAdd -= added;
        }

        @Override
        public void remove(long removed) {
            this.currentRemove -= removed;
        }

        @Override
        public long getMaxRemove() {
            return this.currentRemove;
        }

        @Override
        public long getMaxAdd() {
            return this.currentAdd;
        }
    }
}

