/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.api.utils.ICalculatorCircuit;

public class ItemStackHelper {
    public static boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return ItemStackHelper.equalStacksRegular(stack1, stack2) && !ItemStackHelper.isCircuit(stack1.func_77973_b()) && stack1.func_190916_E() < stack1.func_77976_d();
    }

    public static boolean equalStacksRegular(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack restoreItemStack(ItemStack stack, int size) {
        ItemStack result = stack.func_77946_l();
        if (result.func_190916_E() <= 0) {
            result.func_190920_e(size);
        }
        return result;
    }

    public static boolean isCircuit(Item item) {
        return item instanceof ICalculatorCircuit;
    }

    public static ItemStack grow(ItemStack stack, int stackSize) {
        if (!stack.func_190926_b()) {
            stack.func_190920_e(stack.func_190916_E() + stackSize);
        }
        return stack;
    }

    public static ItemStack shrink(ItemStack stack, int stackSize) {
        if (!stack.func_190926_b()) {
            stack.func_190920_e(stack.func_190916_E() - stackSize);
        }
        if (stack.func_190916_E() <= 0) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack createStack(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = ((ItemStack)obj).func_77946_l();
            if (stack.func_190916_E() == 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", obj));
        }
        return new ItemStack((Block)obj, 1);
    }

    public static boolean matchingModid(ItemStack target, ItemStack stack) {
        String targetID = target.func_77973_b().getRegistryName().func_110624_b();
        String stackID = stack.func_77973_b().getRegistryName().func_110624_b();
        return targetID != null && stackID != null && !targetID.isEmpty() && !stackID.isEmpty() && targetID.equals(stackID);
    }

    public static boolean matchingOreDictID(ItemStack target, ItemStack stack) {
        int[] stackIDs = OreDictionary.getOreIDs((ItemStack)stack);
        int[] filterIDs = OreDictionary.getOreIDs((ItemStack)target);
        for (int sID : stackIDs) {
            for (int fID : filterIDs) {
                if (sID != fID) continue;
                return true;
            }
        }
        return false;
    }
}

