/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.jei;

import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.RecipeHelperV2;

public abstract class JEIRecipeV2<T extends JEIRecipeV2>
implements IRecipeWrapper {
    public RecipeHelperV2 helper;
    public ISonarRecipe recipe;
    public List<List<ItemStack>> inputs;
    public List<ItemStack> outputs;

    public JEIRecipeV2(RecipeHelperV2 helper, ISonarRecipe recipe) {
        this.helper = helper;
        this.recipe = recipe;
        this.inputs = RecipeHelperV2.getJEIInputsFromList(recipe.inputs());
        this.outputs = RecipeHelperV2.getJEIOutputsFromList(recipe.outputs());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

