/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.minetweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import sonar.core.recipes.DefinedRecipeHelper;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeObjectType;
import sonar.core.recipes.RecipeOreStack;

public class SonarRemoveRecipeV2<T extends RecipeHelperV2>
implements IAction {
    public ArrayList ingredients;
    public RecipeObjectType type;
    public ISonarRecipe recipe;
    public boolean liquidStack;
    public boolean wasNull;
    public boolean wrongSize;
    public T helper;

    public SonarRemoveRecipeV2(T helper, RecipeObjectType type, ArrayList ingredients) {
        this.helper = helper;
        this.type = type;
        if (helper instanceof DefinedRecipeHelper && (type == RecipeObjectType.OUTPUT ? ingredients.size() != ((DefinedRecipeHelper)helper).getOutputSize() : ingredients.size() != ((DefinedRecipeHelper)helper).getInputSize())) {
            CraftTweakerAPI.logError((String)("A " + ((RecipeHelperV2)helper).getRecipeID() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<Object> adaptedIngredients = new ArrayList<Object>();
        for (Object output : ingredients) {
            if (output == null) {
                CraftTweakerAPI.logError((String)String.format("An ingredient of a %s was null", ((RecipeHelperV2)helper).getRecipeID()));
                this.wasNull = true;
                return;
            }
            if (output instanceof IItemStack) {
                adaptedIngredients.add(CraftTweakerMC.getItemStack((IItemStack)((IItemStack)output)));
                continue;
            }
            if (output instanceof IOreDictEntry) {
                adaptedIngredients.add(new RecipeOreStack(((IOreDictEntry)output).getName(), 1));
                continue;
            }
            if (output instanceof ILiquidStack) {
                CraftTweakerAPI.logError((String)String.format("A liquid was passed into a %s, aborting!", ((RecipeHelperV2)helper).getRecipeID()));
                this.liquidStack = true;
                return;
            }
            if (!(output instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)String.format("%s: Invalid ingredient: %s", ((RecipeHelperV2)helper).getRecipeID(), output));
                continue;
            }
            adaptedIngredients.add(output);
        }
        this.ingredients = adaptedIngredients;
        this.recipe = type == RecipeObjectType.OUTPUT ? ((RecipeHelperV2)helper).getRecipeFromOutputs(null, adaptedIngredients.toArray()) : ((RecipeHelperV2)helper).getRecipeFromInputs(null, adaptedIngredients.toArray());
    }

    public void apply() {
        boolean removed;
        if (this.recipe == null) {
            CraftTweakerAPI.logError((String)String.format("%s: Removing Recipe - Couldn't find matching recipe %s", ((RecipeHelperV2)this.helper).getRecipeID(), this.ingredients));
            return;
        }
        if (!(this.wasNull || this.liquidStack || this.wrongSize || (removed = ((RecipeHelperV2)((Object)this.helper)).removeRecipe((ISonarRecipe)this.recipe)))) {
            CraftTweakerAPI.logError((String)String.format("%s: Removing Recipe - Failed to remove recipe %s", ((RecipeHelperV2)this.helper).getRecipeID(), this.ingredients));
        }
    }

    public String describe() {
        if (this.recipe == null) {
            return "ERROR: RECIPE IS NULL";
        }
        return String.format("Removing %s recipe (%s = %s)", ((RecipeHelperV2)this.helper).getRecipeID(), this.recipe.inputs(), this.recipe.outputs());
    }
}

