/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.ContainerSonar;
import sonar.core.network.PacketTileSync;
import sonar.core.utils.IWorldPosition;

public abstract class ContainerSync
extends ContainerSonar {
    NBTHelper.SyncType[] types = new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC};
    public INBTSyncable sync;
    public IWorldPosition tile;

    public ContainerSync(INBTSyncable sync, TileEntitySonar tile) {
        this.sync = sync;
        this.tile = tile;
    }

    public ContainerSync(TileEntitySonar tile) {
        if (tile instanceof INBTSyncable) {
            this.sync = tile;
        }
        this.tile = tile;
    }

    public void func_75142_b() {
        if (this.syncInventory()) {
            super.func_75142_b();
        }
        if (this.sync != null && this.field_75149_d != null) {
            NBTHelper.SyncType[] types;
            NBTTagCompound syncData = new NBTTagCompound();
            for (NBTHelper.SyncType type : types = this.getSyncTypes()) {
                this.sync.writeData(syncData, type);
                if (syncData.func_82582_d()) continue;
                for (IContainerListener o : this.field_75149_d) {
                    if (o == null || !(o instanceof EntityPlayerMP)) continue;
                    SonarCore.network.sendTo((IMessage)new PacketTileSync(this.tile.getCoords().getBlockPos(), syncData, type), (EntityPlayerMP)o);
                }
            }
        }
    }

    public NBTHelper.SyncType[] getSyncTypes() {
        return this.types;
    }

    public ContainerSync setTypes(NBTHelper.SyncType[] types) {
        this.types = types;
        return this;
    }

    public boolean syncInventory() {
        return true;
    }
}

