/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.network.PacketCoords;
import sonar.core.utils.Pair;

public class PacketFlexibleOpenGui
extends PacketCoords {
    public boolean change;
    public NBTTagCompound tag;
    public int windowID;

    public PacketFlexibleOpenGui() {
    }

    public PacketFlexibleOpenGui(boolean change, BlockPos pos, int windowID, NBTTagCompound tag) {
        super(pos);
        this.change = change;
        this.tag = tag;
        this.windowID = windowID;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.change = buf.readBoolean();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.windowID = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.change);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        buf.writeInt(this.windowID);
    }

    public static class Handler
    implements IMessageHandler<PacketFlexibleOpenGui, IMessage> {
        public IMessage onMessage(PacketFlexibleOpenGui message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                int id = message.tag.func_74762_e("id");
                Pair<Object, IFlexibleGui> gui = SonarCore.instance.guiHandler.getFlexibleGui(id, player, player.func_130014_f_(), message.pos, message.tag);
                if (message.change) {
                    FlexibleGuiHandler.setLastContainer(player.field_71070_bA, player, ctx.side);
                    FlexibleGuiHandler.setLastGui(gui, player, ctx.side);
                    SonarCore.instance.guiHandler.lastScreen = Minecraft.func_71410_x().field_71462_r;
                }
                FMLClientHandler.instance().showGuiScreen(((IFlexibleGui)gui.b).getClientElement(gui.a, id, player.func_130014_f_(), player, message.tag));
                player.field_71070_bA.field_75152_c = message.windowID;
            });
            return null;
        }
    }
}

