/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.BlockRenderRegister;
import sonar.core.SonarCore;
import sonar.core.client.BlockModelsCache;
import sonar.core.client.renderers.SonarCustomStateMapper;
import sonar.core.network.SonarCommon;
import sonar.core.translate.LocalisationManager;

public class SonarClient
extends SonarCommon {
    private IThreadListener clientListener;
    public static final SonarCustomStateMapper mapper = new SonarCustomStateMapper();
    public static final LocalisationManager translator = new LocalisationManager();

    @Override
    public Object getStateMapper() {
        return mapper;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        SonarCore.logger.info("Registering Renderers");
        BlockRenderRegister.register();
        SonarCore.logger.info("Registered Renderers");
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager resources = (SimpleReloadableResourceManager)manager;
            resources.func_110542_a((IResourceManagerReloadListener)BlockModelsCache.INSTANCE);
            resources.func_110542_a((IResourceManagerReloadListener)translator);
        }
    }

    @Override
    public void serverClose(FMLServerStoppingEvent event) {
        super.serverClose(event);
        translator.clear();
        BlockRenderRegister.register();
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public World getDimension(int dimensionID) {
        return FMLCommonHandler.instance().getEffectiveSide().isClient() ? Minecraft.func_71410_x().field_71441_e : super.getDimension(dimensionID);
    }

    @Override
    public IThreadListener getThreadListener(MessageContext ctx) {
        if (ctx.side.isClient()) {
            if (this.clientListener == null) {
                this.clientListener = Minecraft.func_71410_x();
            }
            return this.clientListener;
        }
        return super.getThreadListener(ctx);
    }
}

