/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public enum ObjectType {
    BOOLEAN(0, Boolean.class),
    BYTE(1, Byte.class),
    SHORT(2, Short.class),
    INTEGER(3, Integer.class),
    LONG(4, Long.class),
    FLOAT(5, Float.class),
    DOUBLE(6, Double.class),
    STRING(8, String.class),
    NBT(10, NBTTagCompound.class),
    NONE(-1, null);

    public static final ArrayList<ObjectType> numbers;
    public int tagType;
    public Class<?> classType;

    private ObjectType(int tagType, Class<?> classType) {
        this.tagType = tagType;
        this.classType = classType;
    }

    public boolean isNumber() {
        return numbers.contains((Object)this);
    }

    public static ObjectType getInfoType(Object obj) {
        for (ObjectType type : ObjectType.values()) {
            if (type.classType == null || !type.classType.isInstance(obj) && !type.classType.isAssignableFrom(obj.getClass())) continue;
            return type;
        }
        return NONE;
    }

    static {
        numbers = Lists.newArrayList((Object[])new ObjectType[]{BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE});
    }
}

