/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;

public class SyncNBTAbstract<T extends INBTSyncable>
extends SyncPart {
    public T obj;
    public Class<T> type;

    public SyncNBTAbstract(Class<T> type, int id) {
        super(id);
        this.type = type;
    }

    public T getObject() {
        return this.obj;
    }

    public void setObject(T object) {
        this.obj = object;
        this.markChanged();
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            if (this.obj != null) {
                this.obj.readData(nbt.func_74775_l(this.getTagName()), type);
            } else {
                this.obj = NBTHelper.instanceNBTSyncable(this.type, nbt.func_74775_l(this.getTagName()));
            }
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.obj != null) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)this.obj.writeData(new NBTTagCompound(), type));
        }
        return nbt;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof SyncNBTAbstract && ((SyncNBTAbstract)obj).obj == this.obj && this.getTagName().equals(((SyncNBTAbstract)obj).getTagName());
    }
}

