/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;

public class SyncNBTAbstractList<T extends INBTSyncable>
extends SyncPart {
    public List<T> objs = new ArrayList<T>();
    public Class<T> type;

    public SyncNBTAbstractList(Class<T> type, int id) {
        super(id);
        this.type = type;
    }

    public SyncNBTAbstractList(Class<T> type, int id, int capacity) {
        super(id);
        this.type = type;
        this.objs = new ArrayList<T>(capacity);
    }

    public List<T> getObjects() {
        return this.objs;
    }

    public void setObjects(List<T> list) {
        this.objs = list;
        this.markChanged();
    }

    public void addObject(T object) {
        if (!this.objs.contains(object)) {
            this.objs.add(object);
            this.markChanged();
        }
    }

    public void removeObject(T object) {
        if (this.objs.remove(object)) {
            this.markChanged();
        }
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            ArrayList<T> newObjs = new ArrayList<T>();
            NBTTagList tagList = nbt.func_150295_c(this.getTagName(), 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                newObjs.add(NBTHelper.instanceNBTSyncable(this.type, tagList.func_150305_b(i)));
            }
            this.objs = newObjs;
        } else if (nbt.func_74767_n(this.getTagName() + 'E')) {
            this.objs = new ArrayList<T>();
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList tagList = new NBTTagList();
        this.objs.forEach(obj -> {
            if (obj != null) {
                tagList.func_74742_a((NBTBase)obj.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
            }
        });
        if (!tagList.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)tagList);
        } else {
            nbt.func_74757_a(this.getTagName() + 'E', true);
        }
        return nbt;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof SyncNBTAbstractList && ((SyncNBTAbstractList)obj).getObjects().equals(this.objs);
    }
}

