/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import java.util.ArrayList;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;

public abstract class DefinedRecipeHelper<T extends ISonarRecipe>
extends RecipeHelperV2<T> {
    private int inputSize;
    private int outputSize;
    public boolean shapeless;

    public DefinedRecipeHelper(int inputSize, int outputSize, boolean shapeless) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.shapeless = shapeless;
        this.addRecipes();
    }

    public void addRecipe(Object ... objs) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        ArrayList<Object> outputs = new ArrayList<Object>();
        ArrayList<Object> additionals = new ArrayList<Object>();
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            if (i < (this.reverseRecipes() ? this.getOutputSize() : this.getInputSize())) {
                inputs.add(obj);
                continue;
            }
            if (i < this.getInputSize() + this.getOutputSize()) {
                outputs.add(obj);
                continue;
            }
            additionals.add(obj);
        }
        this.addRecipe(this.buildDefaultRecipe(this.reverseRecipes() ? outputs : inputs, this.reverseRecipes() ? inputs : outputs, additionals, this.shapeless));
    }

    public boolean reverseRecipes() {
        return false;
    }

    @Override
    public boolean isValidRecipe(ArrayList<ISonarRecipeObject> recipeInputs, ArrayList<ISonarRecipeObject> recipeOutputs) {
        return recipeInputs.size() == this.getInputSize() && recipeOutputs.size() == this.getOutputSize();
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public int getOutputSize() {
        return this.outputSize;
    }
}

