/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.recipes.ISonarRecipeItem;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeObjectType;

public class RecipeOreStack
implements ISonarRecipeObject,
ISonarRecipeItem {
    public String oreType;
    public List<ItemStack> cachedRegister;
    public int stackSize;

    public RecipeOreStack(String oreType, int stackSize) {
        this.oreType = oreType;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack ore : OreDictionary.getOres((String)oreType)) {
            ItemStack newStack = ore.func_77946_l();
            newStack.func_190920_e(stackSize);
            stacks.add(newStack);
        }
        this.cachedRegister = stacks;
        this.stackSize = stackSize;
    }

    @Override
    public Object getValue() {
        return this.cachedRegister;
    }

    @Override
    public boolean isNull() {
        return this.cachedRegister.isEmpty();
    }

    @Override
    public ItemStack getOutputStack() {
        ItemStack stack = this.cachedRegister.get(0).func_77946_l();
        return stack;
    }

    @Override
    public boolean matches(Object object, RecipeObjectType type) {
        if (object instanceof RecipeOreStack) {
            RecipeOreStack oreStack = (RecipeOreStack)object;
            if (oreStack.oreType.equals(this.oreType) && oreStack.stackSize >= this.stackSize) {
                return true;
            }
        } else {
            if (object instanceof String) {
                return this.oreType.equals(object);
            }
            if (object instanceof ItemStack && type.checkStackSize(this.stackSize, ((ItemStack)object).func_190916_E())) {
                int oreID = OreDictionary.getOreID((String)this.oreType);
                for (int id : OreDictionary.getOreIDs((ItemStack)((ItemStack)object))) {
                    if (oreID != id) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<ItemStack> getJEIValue() {
        return this.cachedRegister;
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }
}

