/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.utils;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;

public class CustomColour
implements INBTSyncable {
    public int red;
    public int green;
    public int blue;
    private Integer rgb;

    public CustomColour() {
    }

    public CustomColour(int r, int g, int b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public int getRGB() {
        if (this.rgb == null) {
            this.rgb = FontHelper.getIntFromColor(this.red, this.green, this.blue);
        }
        return this.rgb;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.red = nbt.func_74762_e("red");
        this.green = nbt.func_74762_e("green");
        this.blue = nbt.func_74762_e("blue");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("red", this.red);
        nbt.func_74768_a("green", this.green);
        nbt.func_74768_a("blue", this.blue);
        return nbt;
    }

    public static void writeToBuf(CustomColour colour, ByteBuf buf) {
        buf.writeInt(colour.red);
        buf.writeInt(colour.green);
        buf.writeInt(colour.blue);
    }

    public static CustomColour readFromBuf(ByteBuf buf) {
        return new CustomColour(buf.readInt(), buf.readInt(), buf.readInt());
    }
}

