/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.misc;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.block.BlockPlatform;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.TileHelper;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;

@SideOnly(value=Side.CLIENT)
public class PlacementOverlay {
    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Function.BlockInfo info;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b()) {
            return;
        }
        if (this.isHoldingWrench((EntityPlayer)player) && (info = Function.getBlockInfront((World)player.func_130014_f_(), (EntityPlayer)player, (double)(player.field_71075_bZ.field_75098_d ? 5.0 : 4.0), (boolean)false)) != null && info.block != Blocks.field_150350_a) {
            ItemStack mainHand = player.func_184614_ca();
            EnumHelper.EnumPlatform platform = null;
            if (info.block instanceof BlockPlatform && (platform = BlockPlatform.getEnumPlatform(info.state)) == EnumHelper.EnumPlatform.PLATFORMER && !player.func_70093_af()) {
                return;
            }
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            if (!(mainHand.func_190926_b() || platform == null || platform.TYPE != EnumHelper.EnumPlatformType.FRAME || mainHand.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa) && mainHand.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150429_aA) && mainHand.func_77973_b() != Items.field_151114_aO)) {
                boolean doDraw;
                boolean isUpgrade = mainHand.func_77973_b() == Items.field_151114_aO;
                EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(TileHelper.getPlatformTile((IBlockAccess)player.func_130014_f_(), info.pos));
                boolean bl = torch != null && (torch == EnumHelper.EnumPlatformTorch.NONE ? !isUpgrade : !torch.isUpgrade() && isUpgrade) ? true : (doDraw = false);
                if (doDraw) {
                    double height = info.face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? -0.01 : 16.01;
                    this.renderStart(Tessellator.func_178181_a().func_178180_c(), x, y, z);
                    BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
                    this.renderBrazier(renderer, info.pos, info.face, height, isUpgrade);
                    this.renderFinish(Tessellator.func_178181_a());
                    if (isUpgrade) {
                        return;
                    }
                }
            }
            if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ItemBlock && !(mainHand.func_77973_b() instanceof ItemBlockPlatform) && ((ItemBlock)mainHand.func_77973_b()).func_179222_a(player.func_130014_f_(), info.pos, info.face, (EntityPlayer)player, mainHand)) {
                return;
            }
            if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ItemBlockPlatform && mainHand.func_77952_i() < 50) {
                BlockPos pos;
                TileEntityTypeBase tile;
                int platformType = mainHand.func_77952_i() % 10;
                if (platformType > 3 && platform != null && BlockPlatform.canPlaceRailOn(tile = TileHelper.getPlatformTile((IBlockAccess)player.func_130014_f_(), info.pos))) {
                    this.renderStart(Tessellator.func_178181_a().func_178180_c(), x, y, z);
                    this.renderHandRails(Tessellator.func_178181_a().func_178180_c(), info.pos, tile.getFacing(), TileHelper.getType(tile), platformType == 5, platform.TYPE == EnumHelper.EnumPlatformType.RAMP, platform.TYPE == EnumHelper.EnumPlatformType.FLOOR);
                    this.renderFinish(Tessellator.func_178181_a());
                    return;
                }
                BlockPos blockPos = pos = player.func_130014_f_().func_180495_p(info.pos).func_185904_a().func_76222_j() ? info.pos : info.pos.func_177972_a(info.face);
                if (platformType < 5 && ((ItemBlock)mainHand.func_77973_b()).func_179222_a(player.func_130014_f_(), info.pos, info.face, (EntityPlayer)player, mainHand)) {
                    double hitX;
                    double d = info.face == EnumFacing.WEST ? 0.0 : (hitX = info.face == EnumFacing.EAST ? 1.0 : info.vec.field_72450_a - (double)((int)info.vec.field_72450_a));
                    double hitZ = info.face == EnumFacing.NORTH ? 0.0 : (info.face == EnumFacing.SOUTH ? 1.0 : info.vec.field_72449_c - (double)((int)info.vec.field_72449_c));
                    Triple<BlockPos, EnumFacing, Integer> placement = ItemBlockPlatform.getPlacementData(platformType, player.func_174811_aO(), player.func_130014_f_(), pos, info.face, hitX += hitX < 0.0 ? 1.0 : 0.0, hitZ += hitZ < 0.0 ? 1.0 : 0.0);
                    if (placement != null) {
                        this.renderStart(Tessellator.func_178181_a().func_178180_c(), x, y, z);
                        this.renderOverlay(Tessellator.func_178181_a().func_178180_c(), (BlockPos)placement.getLeft(), (EnumFacing)placement.getMiddle(), platformType, (Integer)placement.getRight());
                        this.renderFinish(Tessellator.func_178181_a());
                        return;
                    }
                }
            }
            if (platform != null) {
                EnumFacing side;
                if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
                    return;
                }
                boolean rotate = platform.TYPE == EnumHelper.EnumPlatformType.FRAME || !player.func_70093_af();
                EnumFacing enumFacing = side = platform.TYPE.VALUE > 0 && platform.TYPE.VALUE < 4 || info.face == EnumFacing.DOWN ? info.face : EnumFacing.UP;
                double height = side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? -0.01 : (side == EnumFacing.UP && platform.TYPE == EnumHelper.EnumPlatformType.FLAT ? 2.01 : 16.01);
                this.renderStart(Tessellator.func_178181_a().func_178180_c(), x, y, z);
                BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
                this.renderWrenchAction(renderer, info.pos, side, height, rotate);
                this.renderFinish(Tessellator.func_178181_a());
            }
        }
    }

    private boolean isHoldingWrench(EntityPlayer player) {
        for (EnumHand hand : EnumHand.values()) {
            Set toolTypes;
            ItemStack held = player.func_184586_b(hand);
            Set set = toolTypes = !held.func_190926_b() ? held.func_77973_b().getToolClasses(held) : null;
            if (toolTypes == null || !toolTypes.contains("wrench")) continue;
            return true;
        }
        return false;
    }

    private void renderStart(BufferBuilder renderer, double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_187441_d((float)4.0f);
        GlStateManager.func_179132_a((boolean)false);
        renderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        renderer.func_178969_c(-x, -y, -z);
    }

    private void renderFinish(Tessellator tessellator) {
        tessellator.func_178180_c().func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private void renderOverlay(BufferBuilder renderer, BlockPos pos, EnumFacing direction, int platformType, int partType) {
        if (direction == EnumFacing.NORTH || direction == EnumFacing.WEST) {
            this.addLine(renderer, pos, 6.0, 0.0, 8.0, 8.0, 0.0, 6.0, false);
        }
        if (direction == EnumFacing.SOUTH || direction == EnumFacing.WEST) {
            this.addLine(renderer, pos, 6.0, 0.0, 8.0, 8.0, 0.0, 10.0, false);
        }
        if (direction == EnumFacing.SOUTH || direction == EnumFacing.EAST) {
            this.addLine(renderer, pos, 10.0, 0.0, 8.0, 8.0, 0.0, 10.0, false);
        }
        if (direction == EnumFacing.NORTH || direction == EnumFacing.EAST) {
            this.addLine(renderer, pos, 10.0, 0.0, 8.0, 8.0, 0.0, 6.0, false);
        }
        boolean rotate = direction.func_176740_k() == EnumFacing.Axis.X;
        switch (platformType) {
            case 0: {
                boolean swap;
                this.addBox(renderer, pos, 0.0, -2.0, 14.0, 16.0, 0.0, 15.0, rotate);
                this.addBox(renderer, pos, 0.0, -2.0, 1.0, 16.0, 0.0, 2.0, rotate);
                if (partType == 10) {
                    this.addBox(renderer, pos, 0.0, 0.0, 0.0, 16.0, 2.0, 16.0, false);
                    break;
                }
                boolean bl = swap = direction == EnumFacing.SOUTH || direction == EnumFacing.WEST;
                if (partType == 0 && !swap || partType == 1 && swap) {
                    this.addBox(renderer, pos, 0.0, 0.0, 0.0, 13.0, 2.0, 16.0, rotate);
                    break;
                }
                this.addBox(renderer, pos, 3.0, 0.0, 0.0, 16.0, 2.0, 16.0, rotate);
                break;
            }
            case 1: {
                boolean swap = direction == EnumFacing.SOUTH || direction == EnumFacing.WEST;
                int left = partType == 0 && !swap || partType == 1 && swap ? 13 : 16;
                int right = partType == 1 && !swap || partType == 0 && swap ? 3 : 0;
                int front = 0;
                int back = 16;
                if (direction == EnumFacing.NORTH || direction == EnumFacing.WEST) {
                    this.addBox(renderer, pos, 0.0, -2.0, 14.0, 16.0, 0.0, 15.0, rotate);
                    this.addBox(renderer, pos, 0.0, 11.0, 1.0, 16.0, 14.0, 2.0, rotate);
                    front = 16;
                    back = 0;
                } else {
                    this.addBox(renderer, pos, 0.0, -2.0, 1.0, 16.0, 0.0, 2.0, rotate);
                    this.addBox(renderer, pos, 0.0, 11.0, 14.0, 16.0, 14.0, 15.0, rotate);
                }
                this.addBox(renderer, pos, left, -1.5, front, right, -1.5, front, right, 14.5, back, left, 14.5, back, left, 0.0, front, right, 0.0, front, right, 16.0, back, left, 16.0, back, rotate);
                if (front < back) {
                    this.addPlane(renderer, pos, left, front, right, front + 2, EnumFacing.Axis.Y, 2.0, rotate);
                    this.addPlane(renderer, pos, left, front + 4, right, front + 6, EnumFacing.Axis.Y, 6.0, rotate);
                    this.addPlane(renderer, pos, left, front + 8, right, front + 10, EnumFacing.Axis.Y, 10.0, rotate);
                    this.addPlane(renderer, pos, left, front + 12, right, front + 14, EnumFacing.Axis.Y, 14.0, rotate);
                    this.addPlane(renderer, pos, left, front, right, front + 2, EnumFacing.Axis.Z, 0.0, rotate);
                    this.addPlane(renderer, pos, left, front + 4, right, front + 6, EnumFacing.Axis.Z, 4.0, rotate);
                    this.addPlane(renderer, pos, left, front + 8, right, front + 10, EnumFacing.Axis.Z, 8.0, rotate);
                    this.addPlane(renderer, pos, left, front + 12, right, front + 14, EnumFacing.Axis.Z, 12.0, rotate);
                    break;
                }
                this.addPlane(renderer, pos, left, back + 14, right, back + 16, EnumFacing.Axis.Y, 2.0, rotate);
                this.addPlane(renderer, pos, left, back + 10, right, back + 12, EnumFacing.Axis.Y, 6.0, rotate);
                this.addPlane(renderer, pos, left, back + 6, right, back + 8, EnumFacing.Axis.Y, 10.0, rotate);
                this.addPlane(renderer, pos, left, back + 2, right, back + 4, EnumFacing.Axis.Y, 14.0, rotate);
                this.addPlane(renderer, pos, left, back + 12, right, back + 14, EnumFacing.Axis.Z, 4.0, rotate);
                this.addPlane(renderer, pos, left, back + 8, right, back + 10, EnumFacing.Axis.Z, 8.0, rotate);
                this.addPlane(renderer, pos, left, back + 4, right, back + 6, EnumFacing.Axis.Z, 12.0, rotate);
                this.addPlane(renderer, pos, left, back, right, back + 2, EnumFacing.Axis.Z, 16.0, rotate);
                break;
            }
            case 2: {
                boolean swap;
                this.addBox(renderer, pos, 0.0, 12.0, 14.0, 16.0, 14.0, 15.0, rotate);
                this.addBox(renderer, pos, 0.0, 12.0, 1.0, 16.0, 14.0, 2.0, rotate);
                if (partType == 10) {
                    this.addBox(renderer, pos, 0.0, 14.0, 0.0, 16.0, 16.0, 16.0, false);
                    this.addBox(renderer, pos, 0.0, 2.0, 0.0, 1.0, 7.0, 16.0, rotate);
                    this.addBox(renderer, pos, 15.0, 2.0, 0.0, 16.0, 7.0, 16.0, rotate);
                    this.addBox(renderer, pos, 6.0, 4.0, 6.0, 10.0, 14.0, 10.0, rotate);
                    this.addBox(renderer, pos, 1.0, 3.0, 10.0, 15.0, 6.0, 12.0, rotate);
                    this.addBox(renderer, pos, 1.0, 3.0, 4.0, 15.0, 6.0, 6.0, rotate);
                    break;
                }
                boolean bl = swap = direction == EnumFacing.SOUTH || direction == EnumFacing.WEST;
                if (partType == 0 && !swap || partType == 1 && swap) {
                    this.addBox(renderer, pos, 0.0, 14.0, 0.0, 13.0, 16.0, 16.0, rotate);
                    this.addBox(renderer, pos, 0.0, 2.0, 0.0, 1.0, 7.0, 16.0, rotate);
                    this.addBox(renderer, pos, 0.5, 2.0, 0.0, 0.5, 7.0, 0.0, 6.5, 13.0, 0.0, 11.5, 13.0, 0.0, 0.5, 2.0, 1.0, 0.5, 7.0, 1.0, 6.5, 13.0, 1.0, 11.5, 13.0, 1.0, rotate);
                    this.addBox(renderer, pos, 0.5, 2.0, 15.0, 0.5, 7.0, 15.0, 6.5, 13.0, 15.0, 11.5, 13.0, 15.0, 0.5, 2.0, 16.0, 0.5, 7.0, 16.0, 6.5, 13.0, 16.0, 11.5, 13.0, 16.0, rotate);
                    break;
                }
                this.addBox(renderer, pos, 3.0, 14.0, 0.0, 16.0, 16.0, 16.0, rotate);
                this.addBox(renderer, pos, 15.0, 2.0, 0.0, 16.0, 7.0, 16.0, rotate);
                this.addBox(renderer, pos, 15.5, 2.0, 0.0, 15.5, 7.0, 0.0, 9.5, 13.0, 0.0, 4.5, 13.0, 0.0, 15.5, 2.0, 1.0, 15.5, 7.0, 1.0, 9.5, 13.0, 1.0, 4.5, 13.0, 1.0, rotate);
                this.addBox(renderer, pos, 15.5, 2.0, 15.0, 15.5, 7.0, 15.0, 9.5, 13.0, 15.0, 4.5, 13.0, 15.0, 15.5, 2.0, 16.0, 15.5, 7.0, 16.0, 9.5, 13.0, 16.0, 4.5, 13.0, 16.0, rotate);
                break;
            }
            case 3: {
                this.addBox(renderer, pos, 15.0, 11.0, 0.0, 16.0, 14.0, 16.0, rotate);
                this.addBox(renderer, pos, 0.0, 11.0, 0.0, 1.0, 14.0, 16.0, rotate);
                this.addBox(renderer, pos, 0.0, 2.0, 0.0, 16.0, 5.0, 1.0, rotate);
                this.addBox(renderer, pos, 0.0, 2.0, 15.0, 16.0, 5.0, 16.0, rotate);
                this.addBox(renderer, pos, 13.0, 0.0, 1.0, 15.0, 16.0, 3.0, rotate);
                this.addBox(renderer, pos, 13.0, 0.0, 13.0, 15.0, 16.0, 15.0, rotate);
                this.addBox(renderer, pos, 1.0, 0.0, 1.0, 3.0, 16.0, 3.0, rotate);
                this.addBox(renderer, pos, 1.0, 0.0, 13.0, 3.0, 16.0, 15.0, rotate);
                break;
            }
            case -4: 
            case 4: {
                boolean[] posts = this.getAndRenderPosts(renderer, pos, direction, partType, false, false, platformType == -4);
                if (partType == 2) {
                    if (posts[0]) {
                        this.addBox(renderer, pos, 12.0, 13.0, 3.0, 16.0, 16.0, 4.0, false);
                        this.addBox(renderer, pos, 12.0, 13.0, 0.0, 13.0, 16.0, 4.0, false);
                    }
                    if (posts[1]) {
                        this.addBox(renderer, pos, 12.0, 13.0, 12.0, 13.0, 16.0, 16.0, false);
                        this.addBox(renderer, pos, 12.0, 13.0, 12.0, 16.0, 16.0, 13.0, false);
                    }
                    if (posts[2]) {
                        this.addBox(renderer, pos, 0.0, 13.0, 3.0, 4.0, 16.0, 4.0, false);
                        this.addBox(renderer, pos, 3.0, 13.0, 0.0, 4.0, 16.0, 4.0, false);
                    }
                    if (!posts[3]) break;
                    this.addBox(renderer, pos, 3.0, 13.0, 12.0, 4.0, 16.0, 16.0, false);
                    this.addBox(renderer, pos, 0.0, 13.0, 12.0, 4.0, 16.0, 13.0, false);
                    break;
                }
                if (posts[0] && posts[2]) {
                    this.addBox(renderer, pos, 0.0, 11.0, 0.0, 16.0, 14.0, 1.0, false);
                    if (posts[1]) {
                        this.addBox(renderer, pos, 0.0, 13.0, 3.0, 13.0, 16.0, 4.0, false);
                    } else if (posts[3]) {
                        this.addBox(renderer, pos, 3.0, 13.0, 3.0, 16.0, 16.0, 4.0, false);
                    } else {
                        this.addBox(renderer, pos, 0.0, 13.0, 3.0, 16.0, 16.0, 4.0, false);
                    }
                }
                if (posts[2] && posts[3]) {
                    this.addBox(renderer, pos, 0.0, 11.0, 0.0, 1.0, 14.0, 16.0, false);
                    if (posts[0]) {
                        this.addBox(renderer, pos, 3.0, 13.0, 3.0, 4.0, 16.0, 16.0, false);
                    } else if (posts[1]) {
                        this.addBox(renderer, pos, 3.0, 13.0, 0.0, 4.0, 16.0, 13.0, false);
                    } else {
                        this.addBox(renderer, pos, 3.0, 13.0, 0.0, 4.0, 16.0, 16.0, false);
                    }
                }
                if (posts[0] && posts[1]) {
                    this.addBox(renderer, pos, 15.0, 11.0, 0.0, 16.0, 14.0, 16.0, false);
                    if (posts[2]) {
                        this.addBox(renderer, pos, 12.0, 13.0, 3.0, 13.0, 16.0, 16.0, false);
                    } else if (posts[3]) {
                        this.addBox(renderer, pos, 12.0, 13.0, 0.0, 13.0, 16.0, 13.0, false);
                    } else {
                        this.addBox(renderer, pos, 12.0, 13.0, 0.0, 13.0, 16.0, 16.0, false);
                    }
                }
                if (!posts[1] || !posts[3]) break;
                this.addBox(renderer, pos, 0.0, 11.0, 15.0, 16.0, 14.0, 16.0, false);
                if (posts[0]) {
                    this.addBox(renderer, pos, 0.0, 13.0, 12.0, 13.0, 16.0, 13.0, false);
                    break;
                }
                if (posts[2]) {
                    this.addBox(renderer, pos, 3.0, 13.0, 12.0, 16.0, 16.0, 13.0, false);
                    break;
                }
                this.addBox(renderer, pos, 0.0, 13.0, 12.0, 16.0, 16.0, 13.0, false);
            }
        }
    }

    private boolean[] getAndRenderPosts(BufferBuilder renderer, BlockPos pos, EnumFacing direction, int partType, boolean isRail, boolean onStair, boolean onFloor) {
        double bottom;
        double top;
        int originalBottom;
        int originalTop;
        boolean[] posts = new boolean[4];
        if (direction == EnumFacing.NORTH || partType != 2 && direction == EnumFacing.WEST || partType == 3 && direction == EnumFacing.EAST) {
            posts[0] = true;
        }
        if (direction == EnumFacing.EAST || partType != 2 && direction == EnumFacing.NORTH || partType == 3 && direction == EnumFacing.SOUTH) {
            posts[1] = true;
        }
        if (direction == EnumFacing.WEST || partType != 2 && direction == EnumFacing.SOUTH || partType == 3 && direction == EnumFacing.NORTH) {
            posts[2] = true;
        }
        if (direction == EnumFacing.SOUTH || partType != 2 && direction == EnumFacing.EAST || partType == 3 && direction == EnumFacing.WEST) {
            posts[3] = true;
        }
        if (partType == 1) {
            for (int index = 0; index < 4; ++index) {
                posts[index] = !posts[index];
            }
        }
        int n = !isRail && onStair ? 32 : (originalTop = isRail ? 15 : 16);
        int n2 = onFloor && isRail ? -4 : (originalBottom = onStair || isRail || onFloor ? -2 : 0);
        if (posts[0]) {
            top = originalTop;
            bottom = originalBottom;
            if (onStair && (direction == EnumFacing.NORTH || direction == EnumFacing.EAST)) {
                top = isRail ? 30.0 : 32.0;
                bottom = 11.0;
            }
            if (isRail) {
                if (posts[1] && !posts[2]) {
                    this.addBox(renderer, pos, 14.0, bottom, 0.0, 16.0, top, 1.0, false);
                } else if (!posts[1] && posts[2]) {
                    this.addBox(renderer, pos, 15.0, bottom, 0.0, 16.0, top, 2.0, false);
                } else {
                    this.addBox(renderer, pos, 14.0, bottom, 0.0, 16.0, top, 2.0, false);
                }
            } else {
                this.addBox(renderer, pos, 13.0, bottom, 1.0, 15.0, top, 3.0, false);
            }
        }
        if (posts[1]) {
            top = originalTop;
            bottom = originalBottom;
            if (onStair && (direction == EnumFacing.SOUTH || direction == EnumFacing.EAST)) {
                top = isRail ? 30.0 : 32.0;
                bottom = 11.0;
            }
            if (isRail) {
                if (posts[0] && !posts[3]) {
                    this.addBox(renderer, pos, 14.0, bottom, 15.0, 16.0, top, 16.0, false);
                } else if (!posts[0] && posts[3]) {
                    this.addBox(renderer, pos, 15.0, bottom, 14.0, 16.0, top, 16.0, false);
                } else {
                    this.addBox(renderer, pos, 14.0, bottom, 14.0, 16.0, top, 16.0, false);
                }
            } else {
                this.addBox(renderer, pos, 13.0, bottom, 13.0, 15.0, top, 15.0, false);
            }
        }
        if (posts[2]) {
            top = originalTop;
            bottom = originalBottom;
            if (onStair && (direction == EnumFacing.NORTH || direction == EnumFacing.WEST)) {
                top = isRail ? 30.0 : 32.0;
                bottom = 11.0;
            }
            if (isRail) {
                if (posts[0] && !posts[3]) {
                    this.addBox(renderer, pos, 0.0, bottom, 0.0, 1.0, top, 2.0, false);
                } else if (!posts[0] && posts[3]) {
                    this.addBox(renderer, pos, 0.0, bottom, 0.0, 2.0, top, 1.0, false);
                } else {
                    this.addBox(renderer, pos, 0.0, bottom, 0.0, 2.0, top, 2.0, false);
                }
            } else {
                this.addBox(renderer, pos, 1.0, bottom, 1.0, 3.0, top, 3.0, false);
            }
        }
        if (posts[3]) {
            top = originalTop;
            bottom = originalBottom;
            if (onStair && (direction == EnumFacing.SOUTH || direction == EnumFacing.WEST)) {
                top = isRail ? 30.0 : 32.0;
                bottom = 11.0;
            }
            if (isRail) {
                if (posts[1] && !posts[2]) {
                    this.addBox(renderer, pos, 0.0, bottom, 14.0, 1.0, top, 16.0, false);
                } else if (!posts[1] && posts[2]) {
                    this.addBox(renderer, pos, 0.0, bottom, 15.0, 2.0, top, 16.0, false);
                } else {
                    this.addBox(renderer, pos, 0.0, bottom, 14.0, 2.0, top, 16.0, false);
                }
            } else {
                this.addBox(renderer, pos, 1.0, bottom, 13.0, 3.0, top, 15.0, false);
            }
        }
        return posts;
    }

    private void renderHandRails(BufferBuilder renderer, BlockPos pos, EnumFacing direction, int partType, boolean isRail, boolean onStair, boolean onFloor) {
        if (onFloor) {
            pos = pos.func_177984_a();
        }
        if (!onStair) {
            partType = partType == 10 ? -1 : (partType > 5 ? 3 : (partType > 1 ? 2 : partType));
        } else if (partType == 2) {
            partType = -1;
        }
        if (partType == -1) {
            this.addBox(renderer, pos, 6.5, 6.5, 6.5, 9.5, 9.5, 9.5, false);
            return;
        }
        if (!onStair && !isRail) {
            this.renderOverlay(renderer, pos, direction, onFloor ? -4 : 4, partType);
            return;
        }
        boolean[] posts = this.getAndRenderPosts(renderer, pos, direction, partType, isRail, onStair, onFloor);
        if (!onStair) {
            if (partType == 2) {
                if (posts[0]) {
                    this.addBox(renderer, pos, 13.0, 14.0, 0.0, 16.0, 16.0, 3.0, false);
                    this.addBox(renderer, pos, 13.0, 4.0, 0.0, 14.0, 7.0, 3.0, false);
                    this.addBox(renderer, pos, 13.0, 4.0, 2.0, 16.0, 7.0, 3.0, false);
                }
                if (posts[1]) {
                    this.addBox(renderer, pos, 13.0, 14.0, 13.0, 16.0, 16.0, 16.0, false);
                    this.addBox(renderer, pos, 13.0, 4.0, 13.0, 14.0, 7.0, 16.0, false);
                    this.addBox(renderer, pos, 13.0, 4.0, 13.0, 16.0, 7.0, 14.0, false);
                }
                if (posts[2]) {
                    this.addBox(renderer, pos, 0.0, 14.0, 0.0, 3.0, 16.0, 3.0, false);
                    this.addBox(renderer, pos, 2.0, 4.0, 0.0, 3.0, 7.0, 3.0, false);
                    this.addBox(renderer, pos, 0.0, 4.0, 2.0, 3.0, 7.0, 3.0, false);
                }
                if (posts[3]) {
                    this.addBox(renderer, pos, 0.0, 14.0, 13.0, 3.0, 16.0, 16.0, false);
                    this.addBox(renderer, pos, 0.0, 4.0, 13.0, 3.0, 7.0, 14.0, false);
                    this.addBox(renderer, pos, 2.0, 4.0, 13.0, 3.0, 7.0, 16.0, false);
                }
            } else {
                if (posts[0] && posts[2]) {
                    this.addBox(renderer, pos, 0.0, 14.0, 0.0, 16.0, 16.0, 3.0, false);
                    if (posts[1]) {
                        this.addBox(renderer, pos, 0.0, 4.0, 2.0, 14.0, 7.0, 3.0, false);
                    } else if (posts[3]) {
                        this.addBox(renderer, pos, 2.0, 4.0, 2.0, 16.0, 7.0, 3.0, false);
                    } else {
                        this.addBox(renderer, pos, 0.0, 4.0, 2.0, 16.0, 7.0, 3.0, false);
                    }
                }
                if (posts[2] && posts[3]) {
                    this.addBox(renderer, pos, 0.0, 14.0, 0.0, 3.0, 16.0, 16.0, false);
                    if (posts[0]) {
                        this.addBox(renderer, pos, 2.0, 4.0, 2.0, 3.0, 7.0, 16.0, false);
                    } else if (posts[1]) {
                        this.addBox(renderer, pos, 2.0, 4.0, 0.0, 3.0, 7.0, 14.0, false);
                    } else {
                        this.addBox(renderer, pos, 2.0, 4.0, 0.0, 3.0, 7.0, 16.0, false);
                    }
                }
                if (posts[0] && posts[1]) {
                    this.addBox(renderer, pos, 13.0, 14.0, 0.0, 16.0, 16.0, 16.0, false);
                    if (posts[2]) {
                        this.addBox(renderer, pos, 13.0, 4.0, 2.0, 14.0, 7.0, 16.0, false);
                    } else if (posts[3]) {
                        this.addBox(renderer, pos, 13.0, 4.0, 0.0, 14.0, 7.0, 14.0, false);
                    } else {
                        this.addBox(renderer, pos, 13.0, 4.0, 0.0, 14.0, 7.0, 16.0, false);
                    }
                }
                if (posts[1] && posts[3]) {
                    this.addBox(renderer, pos, 0.0, 14.0, 13.0, 16.0, 16.0, 16.0, false);
                    if (posts[0]) {
                        this.addBox(renderer, pos, 0.0, 4.0, 13.0, 14.0, 7.0, 14.0, false);
                    } else if (posts[2]) {
                        this.addBox(renderer, pos, 2.0, 4.0, 13.0, 16.0, 7.0, 14.0, false);
                    } else {
                        this.addBox(renderer, pos, 0.0, 4.0, 13.0, 16.0, 7.0, 14.0, false);
                    }
                }
            }
        } else {
            int left;
            boolean swap;
            boolean rotate = direction.func_176740_k() == EnumFacing.Axis.X;
            boolean bl = swap = direction == EnumFacing.SOUTH || direction == EnumFacing.WEST;
            int n = partType == 0 && !swap || partType == 1 && swap ? (isRail ? 13 : 13) : (left = isRail ? 0 : 3);
            int right = partType == 1 && !swap || partType == 0 && swap ? (isRail ? 3 : 4) : (isRail ? 16 : 12);
            int front = 0;
            int back = 16;
            if (direction == EnumFacing.NORTH || direction == EnumFacing.WEST) {
                front = 16;
                back = 0;
            }
            int y1 = isRail ? 14 : 13;
            int y2 = isRail ? 30 : 29;
            this.addBox(renderer, pos, left, y1, front, right, y1, front, right, y2, back, left, y2, back, left, 16.0, front, right, 16.0, front, right, 32.0, back, left, 32.0, back, rotate);
            if (!isRail) {
                left = partType == 0 && !swap || partType == 1 && swap ? 15 : 0;
                right = partType == 1 && !swap || partType == 0 && swap ? 1 : 16;
                this.addBox(renderer, pos, left, 11.0, front, right, 14.0, back, rotate);
                this.addBox(renderer, pos, left, 27.0, front, right, 30.0, back, rotate);
            }
        }
    }

    private void renderBrazier(BufferBuilder renderer, BlockPos pos, EnumFacing side, double height, boolean isUpgrade) {
        if (isUpgrade) {
            double offset = side.func_176740_k() == EnumFacing.Axis.Y ? 1.5 : 0.0;
            this.addSidedLine(renderer, pos, 7.0, height, offset + 6.0, 8.0, height, offset + 5.0, side);
            this.addSidedLine(renderer, pos, 9.0, height, offset + 6.0, 8.0, height, offset + 5.0, side);
            this.addSidedLine(renderer, pos, 7.0, height, offset + 6.5, 8.0, height, offset + 5.5, side);
            this.addSidedLine(renderer, pos, 9.0, height, offset + 6.5, 8.0, height, offset + 5.5, side);
            this.addSidedLine(renderer, pos, 7.5, height, offset + 6.5, 8.5, height, offset + 6.5, side);
            this.addSidedLine(renderer, pos, 7.5, height, offset + 7.0, 8.5, height, offset + 7.0, side);
            this.addSidedLine(renderer, pos, 7.5, height, offset + 7.5, 8.5, height, offset + 7.5, side);
        } else {
            this.addBox(renderer, pos, 5.0, 9.0, 5.0, 11.0, 9.5, 11.0, false);
            this.addBox(renderer, pos, 7.5, 7.0, 5.0, 8.5, 9.0, 6.0, false);
            this.addBox(renderer, pos, 7.5, 7.0, 10.0, 8.5, 9.0, 11.0, false);
            this.addBox(renderer, pos, 5.0, 7.0, 7.5, 6.0, 9.0, 8.5, false);
            this.addBox(renderer, pos, 10.0, 7.0, 7.5, 11.0, 9.0, 8.5, false);
            this.addBox(renderer, pos, 5.0, 9.8, 4.4, 5.0, 10.3, 4.6, 5.0, 8.9, 7.8, 5.0, 8.5, 7.7, 11.0, 9.8, 4.4, 11.0, 10.3, 4.6, 11.0, 8.9, 7.8, 11.0, 8.5, 7.7, false);
            this.addBox(renderer, pos, 5.0, 9.8, 4.4, 5.0, 10.3, 4.6, 5.0, 8.9, 7.8, 5.0, 8.5, 7.7, 11.0, 9.8, 4.4, 11.0, 10.3, 4.6, 11.0, 8.9, 7.8, 11.0, 8.5, 7.7, true);
            this.addBox(renderer, pos, 5.0, 9.8, 11.6, 5.0, 10.3, 11.4, 5.0, 8.9, 8.2, 5.0, 8.5, 8.3, 11.0, 9.8, 11.6, 11.0, 10.3, 11.4, 11.0, 8.9, 8.2, 11.0, 8.5, 8.3, false);
            this.addBox(renderer, pos, 5.0, 9.8, 11.6, 5.0, 10.3, 11.4, 5.0, 8.9, 8.2, 5.0, 8.5, 8.3, 11.0, 9.8, 11.6, 11.0, 10.3, 11.4, 11.0, 8.9, 8.2, 11.0, 8.5, 8.3, true);
        }
    }

    private void renderWrenchAction(BufferBuilder renderer, BlockPos pos, EnumFacing side, double height, boolean rotate) {
        if (!rotate || side.func_176740_k() == EnumFacing.Axis.Y) {
            this.addSidedLine(renderer, pos, 3.5, height, 6.5, 3.5, height, 4.5, side);
            this.addSidedLine(renderer, pos, 3.5, height, 4.5, 4.5, height, 3.5, side);
            this.addSidedLine(renderer, pos, 4.5, height, 3.5, 6.5, height, 3.5, side);
            this.addSidedLine(renderer, pos, 5.5, height, 2.5, 6.5, height, 3.5, side);
            this.addSidedLine(renderer, pos, 6.5, height, 3.5, 5.5, height, 4.5, side);
            this.addSidedLine(renderer, pos, 12.5, height, 9.5, 12.5, height, 11.5, side);
            this.addSidedLine(renderer, pos, 12.5, height, 11.5, 11.5, height, 12.5, side);
            this.addSidedLine(renderer, pos, 11.5, height, 12.5, 9.5, height, 12.5, side);
            this.addSidedLine(renderer, pos, 10.5, height, 11.5, 9.5, height, 12.5, side);
            this.addSidedLine(renderer, pos, 9.5, height, 12.5, 10.5, height, 13.5, side);
        }
        if (rotate) {
            if (side.func_176740_k() != EnumFacing.Axis.Y) {
                this.addSidedLine(renderer, pos, 4.0, height, 8.0, 4.0, height, 7.0, side);
                this.addSidedLine(renderer, pos, 5.0, height, 7.0, 4.0, height, 7.0, side);
                this.addSidedLine(renderer, pos, 4.0, height, 7.0, 5.0, height, 8.0, side);
                this.addSidedLine(renderer, pos, 5.0, height, 8.0, 7.0, height, 8.0, side);
                this.addSidedLine(renderer, pos, 9.7, height, 7.3, 9.0, height, 8.0, side);
                this.addSidedLine(renderer, pos, 9.7, height, 8.7, 9.0, height, 8.0, side);
                this.addSidedLine(renderer, pos, 9.0, height, 8.0, 11.0, height, 8.0, side);
                this.addSidedLine(renderer, pos, 11.0, height, 8.0, 12.0, height, 7.0, side);
            } else {
                this.addSidedLine(renderer, pos, 9.5, height, 3.5, 11.5, height, 3.5, side);
                this.addSidedLine(renderer, pos, 11.5, height, 3.5, 12.5, height, 4.5, side);
                this.addSidedLine(renderer, pos, 12.5, height, 4.5, 12.5, height, 6.5, side);
                this.addSidedLine(renderer, pos, 11.5, height, 5.5, 12.5, height, 6.5, side);
                this.addSidedLine(renderer, pos, 12.5, height, 6.5, 13.5, height, 5.5, side);
                this.addSidedLine(renderer, pos, 6.5, height, 12.5, 4.5, height, 12.5, side);
                this.addSidedLine(renderer, pos, 4.5, height, 12.5, 3.5, height, 11.5, side);
                this.addSidedLine(renderer, pos, 3.5, height, 11.5, 3.5, height, 9.5, side);
                this.addSidedLine(renderer, pos, 2.5, height, 10.5, 3.5, height, 9.5, side);
                this.addSidedLine(renderer, pos, 3.5, height, 9.5, 4.5, height, 10.5, side);
            }
        } else {
            this.addSidedLine(renderer, pos, 9.5, height, 3.5, 12.5, height, 3.5, side);
            this.addSidedLine(renderer, pos, 12.5, height, 3.5, 12.5, height, 6.5, side);
            this.addSidedLine(renderer, pos, 12.5, height, 6.5, 9.5, height, 6.5, side);
            this.addSidedLine(renderer, pos, 9.5, height, 6.5, 9.5, height, 3.5, side);
            this.addSidedLine(renderer, pos, 3.5, height, 9.5, 6.5, height, 9.5, side);
            this.addSidedLine(renderer, pos, 6.5, height, 9.5, 6.5, height, 12.5, side);
            this.addSidedLine(renderer, pos, 6.5, height, 12.5, 3.5, height, 12.5, side);
            this.addSidedLine(renderer, pos, 3.5, height, 12.5, 3.5, height, 9.5, side);
        }
    }

    private void addBox(BufferBuilder renderer, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double x5, double y5, double z5, double x6, double y6, double z6, double x7, double y7, double z7, double x8, double y8, double z8, boolean rotate) {
        this.addLine(renderer, pos, x1, y1, z1, x2, y2, z2, rotate);
        this.addLine(renderer, pos, x2, y2, z2, x3, y3, z3, rotate);
        this.addLine(renderer, pos, x3, y3, z3, x4, y4, z4, rotate);
        this.addLine(renderer, pos, x4, y4, z4, x1, y1, z1, rotate);
        this.addLine(renderer, pos, x5, y5, z5, x6, y6, z6, rotate);
        this.addLine(renderer, pos, x6, y6, z6, x7, y7, z7, rotate);
        this.addLine(renderer, pos, x7, y7, z7, x8, y8, z8, rotate);
        this.addLine(renderer, pos, x8, y8, z8, x5, y5, z5, rotate);
        this.addLine(renderer, pos, x1, y1, z1, x5, y5, z5, rotate);
        this.addLine(renderer, pos, x2, y2, z2, x6, y6, z6, rotate);
        this.addLine(renderer, pos, x3, y3, z3, x7, y7, z7, rotate);
        this.addLine(renderer, pos, x4, y4, z4, x8, y8, z8, rotate);
    }

    private void addBox(BufferBuilder renderer, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, boolean rotate) {
        this.addLine(renderer, pos, x1, y1, z1, x2, y1, z1, rotate);
        this.addLine(renderer, pos, x1, y1, z2, x2, y1, z2, rotate);
        this.addLine(renderer, pos, x1, y1, z1, x1, y1, z2, rotate);
        this.addLine(renderer, pos, x2, y1, z1, x2, y1, z2, rotate);
        this.addLine(renderer, pos, x1, y2, z1, x2, y2, z1, rotate);
        this.addLine(renderer, pos, x1, y2, z2, x2, y2, z2, rotate);
        this.addLine(renderer, pos, x1, y2, z1, x1, y2, z2, rotate);
        this.addLine(renderer, pos, x2, y2, z1, x2, y2, z2, rotate);
        this.addLine(renderer, pos, x1, y1, z1, x1, y2, z1, rotate);
        this.addLine(renderer, pos, x1, y1, z2, x1, y2, z2, rotate);
        this.addLine(renderer, pos, x2, y1, z1, x2, y2, z1, rotate);
        this.addLine(renderer, pos, x2, y1, z2, x2, y2, z2, rotate);
    }

    private void addPlane(BufferBuilder renderer, BlockPos pos, double pt1, double pt2, double pt3, double pt4, EnumFacing.Axis axis, double com, boolean rotate) {
        switch (axis) {
            case X: {
                this.addLine(renderer, pos, com, pt1, pt2, com, pt3, pt2, rotate);
                this.addLine(renderer, pos, com, pt1, pt4, com, pt3, pt4, rotate);
                this.addLine(renderer, pos, com, pt1, pt2, com, pt1, pt4, rotate);
                this.addLine(renderer, pos, com, pt3, pt2, com, pt3, pt4, rotate);
                break;
            }
            case Y: {
                this.addLine(renderer, pos, pt1, com, pt2, pt3, com, pt2, rotate);
                this.addLine(renderer, pos, pt1, com, pt4, pt3, com, pt4, rotate);
                this.addLine(renderer, pos, pt1, com, pt2, pt1, com, pt4, rotate);
                this.addLine(renderer, pos, pt3, com, pt2, pt3, com, pt4, rotate);
                break;
            }
            case Z: {
                this.addLine(renderer, pos, pt1, pt2, com, pt3, pt2, com, rotate);
                this.addLine(renderer, pos, pt1, pt4, com, pt3, pt4, com, rotate);
                this.addLine(renderer, pos, pt1, pt2, com, pt1, pt4, com, rotate);
                this.addLine(renderer, pos, pt3, pt2, com, pt3, pt4, com, rotate);
            }
        }
    }

    private void addSidedLine(BufferBuilder renderer, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                this.addLine(renderer, pos, x1, y1, z1, x2, y2, z2, false);
                break;
            }
            case UP: {
                this.addLine(renderer, pos, x1, y1, z1, x2, y2, z2, false);
                break;
            }
            case NORTH: {
                this.addLine(renderer, pos, 16.0 - x1, 16.0 - z1, y1, 16.0 - x2, 16.0 - z2, y2, false);
                break;
            }
            case SOUTH: {
                this.addLine(renderer, pos, x1, 16.0 - z1, y1, x2, 16.0 - z2, y2, false);
                break;
            }
            case WEST: {
                this.addLine(renderer, pos, y1, 16.0 - z1, x1, y2, 16.0 - z2, x2, false);
                break;
            }
            case EAST: {
                this.addLine(renderer, pos, y1, 16.0 - z1, 16.0 - x1, y2, 16.0 - z2, 16.0 - x2, false);
            }
        }
    }

    private void addLine(BufferBuilder renderer, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2, boolean rotate) {
        this.add(renderer, pos, x1, y1, z1, rotate);
        this.add(renderer, pos, x2, y2, z2, rotate);
    }

    private void add(BufferBuilder renderer, BlockPos pos, double x, double y, double z, boolean rotate) {
        double d = y == 0.0 ? 0.01 : (y = y == 16.0 ? 15.99 : y);
        if (rotate) {
            renderer.func_181662_b((double)pos.func_177958_n() + z * 0.0625, (double)pos.func_177956_o() + y * 0.0625, (double)pos.func_177952_p() + x * 0.0625).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        } else {
            renderer.func_181662_b((double)pos.func_177958_n() + x * 0.0625, (double)pos.func_177956_o() + y * 0.0625, (double)pos.func_177952_p() + z * 0.0625).func_181666_a(1.0f, 0.0f, 0.0f, 0.5f).func_181675_d();
        }
    }
}

