/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import net.minecraft.item.ItemStack;

public enum ChiselToolType {
    CHISEL(true, true),
    BIT(true, false),
    POSITIVEPATTERN(true, true),
    TAPEMEASURE(true, true),
    NEGATIVEPATTERN(false, false),
    MIRRORPATTERN(false, false);

    private final boolean hasMenu;
    private final boolean hasItemSettings;

    private ChiselToolType(boolean menu, boolean itemSettings) {
        this.hasMenu = menu;
        this.hasItemSettings = itemSettings;
    }

    public IToolMode getMode(ItemStack ei) {
        if (this == CHISEL) {
            return ChiselMode.getMode(ei);
        }
        if (this == POSITIVEPATTERN) {
            return PositivePatternMode.getMode(ei);
        }
        if (this == TAPEMEASURE) {
            return TapeMeasureModes.getMode(ei);
        }
        throw new NullPointerException();
    }

    public boolean hasMenu() {
        return this.hasMenu;
    }

    public List<IToolMode> getAvailableModes() {
        if (this.isBitOrChisel()) {
            ChiselMode[] orderedModes;
            ArrayList<IToolMode> modes = new ArrayList<IToolMode>();
            EnumSet<ChiselMode> used = EnumSet.noneOf(ChiselMode.class);
            for (ChiselMode mode : orderedModes = new ChiselMode[]{ChiselMode.SINGLE, ChiselMode.LINE, ChiselMode.PLANE, ChiselMode.CONNECTED_PLANE, ChiselMode.CONNECTED_MATERIAL, ChiselMode.DRAWN_REGION, ChiselMode.SAME_MATERIAL}) {
                if (mode.isDisabled) continue;
                modes.add(mode);
                used.add(mode);
            }
            for (ChiselMode mode : ChiselMode.values()) {
                if (mode.isDisabled || used.contains(mode)) continue;
                modes.add(mode);
            }
            return modes;
        }
        if (this == POSITIVEPATTERN) {
            return this.asArray(PositivePatternMode.values());
        }
        if (this == TAPEMEASURE) {
            return this.asArray(TapeMeasureModes.values());
        }
        return Collections.emptyList();
    }

    private List<IToolMode> asArray(Object[] values) {
        return Arrays.asList((IToolMode[])values);
    }

    public boolean isBitOrChisel() {
        return this == BIT || this == CHISEL;
    }

    public boolean hasPerToolSettings() {
        return this.hasItemSettings;
    }

    public boolean requiresPerToolSettings() {
        return this == POSITIVEPATTERN || this == TAPEMEASURE;
    }
}

