/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod;

import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import sonar.calculator.mod.Calculator;

public class CalculatorConfig
extends Calculator {
    private static final List<IntegerConfig> integerConfigs = new ArrayList<IntegerConfig>();
    private static final Map<String, Integer> integers = new THashMap();
    public static boolean timeEffect;
    public static boolean beamEffect;
    public static boolean enableWaila;
    public static boolean enableGrenades;
    public static boolean enableToolModels;
    public static float locatorMultiplier;
    public static Property atomicblackList;
    public static Property blocksblackList;
    public static Property itemsblackList;

    public static void addInteger(String name, String usageType, int min, int defaultValue, int max, boolean useBoth) {
        integerConfigs.add(new IntegerConfig(name, usageType, min, defaultValue, max, useBoth));
    }

    public static int getInteger(String name) {
        return integers.get(name);
    }

    public static void initConfiguration(FMLPreInitializationEvent event) {
        CalculatorConfig.registerInteger();
        CalculatorConfig.loadMainConfig();
        CalculatorConfig.loadAtomicBlacklist();
        CalculatorConfig.loadBlocks();
        CalculatorConfig.loadItems();
    }

    public static void registerInteger() {
        CalculatorConfig.addInteger("Calculator", "Energy Storage", 1000, 10, 50000, false);
        CalculatorConfig.addInteger("Crafting Calculator", "Energy Storage", 5000, 10, 50000, false);
        CalculatorConfig.addInteger("Scientific Calculator", "Energy Storage", 2000, 10, 50000, false);
        CalculatorConfig.addInteger("Terrain Module", "Energy Storage", 400, 10, 50000, false);
        CalculatorConfig.addInteger("Advanced Terrain Module", "Energy Storage", 2000, 10, 50000, false);
        CalculatorConfig.addInteger("Energy Module", "Energy Storage", 100000, 1000, 500000, false);
        CalculatorConfig.addInteger("Standard Machine", "Energy Storage", 50000, 1000, 1000000, false);
        CalculatorConfig.addInteger("Starch Extractor", "Generation", 40, 1, 128, false);
        CalculatorConfig.addInteger("Redstone Extractor", "Generation", 80, 4, 192, false);
        CalculatorConfig.addInteger("Glowstone Extractor", "Generation", 160, 16, 256, false);
        CalculatorConfig.addInteger("Conductor Mast", "Generation", 5000, 200, 5000000, false);
        CalculatorConfig.addInteger("Weather Station", "Generation", 1000, 200, 5000000, false);
        CalculatorConfig.addInteger("Growth Energy", "Greenhouses", 150, 1, 50000, false);
        CalculatorConfig.addInteger("Build Energy", "Greenhouses", 100, 1, 50000, false);
        CalculatorConfig.addInteger("Plant Energy", "Greenhouses", 50, 1, 50000, false);
        CalculatorConfig.addInteger("Adding Farmland", "Greenhouses", 50, 1, 50000, false);
        CalculatorConfig.addInteger("Adding Water", "Greenhouses", 1000, 1, 50000, false);
        CalculatorConfig.addInteger("Scarecrow Tick Rate", "Scarecrow", 500, 1, 10000, false);
        CalculatorConfig.addInteger("Scarecrow Range", "Scarecrow", 3, 1, 25, false);
        CalculatorConfig.addInteger("Weather Controller", "Energy Usage", 250000, 1, 1000000, false);
        CalculatorConfig.addInteger("Reinforced Furnace", "Energy Usage", 500, 1, 50000, true);
        CalculatorConfig.addInteger("Reinforced Furnace", "Base Speed", 200, 20, 10000, true);
        CalculatorConfig.addInteger("Stone Seperator", "Energy Usage", 500, 1, 50000, true);
        CalculatorConfig.addInteger("Stone Seperator", "Base Speed", 200, 20, 10000, true);
        CalculatorConfig.addInteger("Algorithm Seperator", "Energy Usage", 5000, 1, 50000, true);
        CalculatorConfig.addInteger("Algorithm Seperator", "Base Speed", 200, 20, 10000, true);
        CalculatorConfig.addInteger("Extraction Chamber", "Energy Usage", 5000, 1, 50000, true);
        CalculatorConfig.addInteger("Extraction Chamber", "Base Speed", 1000, 20, 10000, true);
        CalculatorConfig.addInteger("Reassembly Chamber", "Energy Usage", 1000, 1, 50000, true);
        CalculatorConfig.addInteger("Reassembly Chamber", "Base Speed", 1000, 20, 10000, true);
        CalculatorConfig.addInteger("Restoration Chamber", "Energy Usage", 1000, 1, 50000, true);
        CalculatorConfig.addInteger("Restoration Chamber", "Base Speed", 1000, 20, 10000, true);
        CalculatorConfig.addInteger("Precision Chamber", "Energy Usage", 5000, 1, 50000, true);
        CalculatorConfig.addInteger("Precision Chamber", "Base Speed", 500, 20, 10000, true);
        CalculatorConfig.addInteger("Processing Chamber", "Energy Usage", 1000, 1, 50000, true);
        CalculatorConfig.addInteger("Processing Chamber", "Base Speed", 500, 20, 10000, true);
    }

    public static void loadMainConfig() {
        Configuration config = new Configuration(new File("config/calculator/Calculator-Config.cfg"));
        config.load();
        for (IntegerConfig usageConfig : integerConfigs) {
            int usage = config.getInt(usageConfig.name, usageConfig.usageType, usageConfig.defaultValue, usageConfig.min, usageConfig.max, usageConfig.name);
            String name = usageConfig.name;
            if (usageConfig.useBoth()) {
                name = name + usageConfig.usageType;
            }
            integers.put(name, usage);
        }
        timeEffect = config.getBoolean("Locator Can Change Time", "settings", true, "Calculator Locator");
        beamEffect = config.getBoolean("Locator has a beam", "settings", true, "Calculator Locator");
        enableWaila = config.getBoolean("enable Waila integration", "api", true, "Waila");
        enableGrenades = config.getBoolean("allow grenades?", "settings", true, "Grenades");
        enableToolModels = config.getBoolean("Enable Tool Models", "settings", true, "Tool Models");
        locatorMultiplier = config.getFloat("Calculator Locator Multiplier", "Generation", 2.0f, 0.1f, 64.0f, "Calculator Locator Multiplier");
        config.save();
    }

    public static void loadAtomicBlacklist() {
        Configuration blacklist = new Configuration(new File("config/calculator/AtomicMultiplier-BlackList.cfg"));
        blacklist.load();
        String[] blackDefaults = new String[]{"minecraft:nether_star", "Calculator:AtomicMultiplier", "Calculator:EndBlock", "Calculator:ElectricBlock", "Calculator:FlawlessFireBlock", "Calculator:FlawlessBlock", "Calculator:ElectricDiamond", "Calculator:FlawlessFireDiamond", "Calculator:FlawlessDiamond"};
        atomicblackList = blacklist.get("Atomic Multiplier Blacklist", "disabled", blackDefaults);
        blacklist.save();
    }

    public static void loadBlocks() {
        Configuration blocks = new Configuration(new File("config/calculator/Blocks-BlackList.cfg"));
        blocks.load();
        String[] blockExamples = new String[]{"ExampleBlock", "ExampleBlock2"};
        blocksblackList = blocks.get("Block Config", "Disabled", blockExamples);
        blocks.save();
    }

    public static void loadItems() {
        Configuration items = new Configuration(new File("config/calculator/Items-BlackList.cfg"));
        items.load();
        String[] itemExamples = new String[]{"ExampleItem", "ExampleItem2"};
        itemsblackList = items.get("Item Config", "Disabled", itemExamples);
        items.save();
    }

    private static boolean isBlockEnabled(String block) {
        if (block != null) {
            String[] blacklisted;
            for (String aBlacklisted : blacklisted = blocksblackList.getStringList()) {
                if (aBlacklisted == null || !aBlacklisted.equals(block)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isItemEnabled(String item) {
        if (item != null) {
            String[] blacklisted;
            for (String aBlacklisted : blacklisted = itemsblackList.getStringList()) {
                if (aBlacklisted == null || !aBlacklisted.equals(item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEnabled(ItemStack stack) {
        return true;
    }

    public static class IntegerConfig {
        public String name;
        public String usageType;
        public int min;
        public int defaultValue;
        public int max;
        public boolean useBoth;

        public IntegerConfig(String name, String usageType, int defaultValue, int min, int max, boolean useBoth) {
            this.name = name;
            this.usageType = usageType;
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
            this.useBoth = useBoth;
        }

        public boolean useBoth() {
            return this.useBoth;
        }
    }
}

