/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.machines;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.common.containers.ContainerAdvancedGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityAdvancedGreenhouse;
import sonar.core.SonarCore;
import sonar.core.api.machines.IPausable;
import sonar.core.client.gui.GuiSonarTile;
import sonar.core.client.gui.SonarButtons;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.IWorldPosition;

public class GuiAdvancedGreenhouse
extends GuiSonarTile {
    DecimalFormat dec = new DecimalFormat("##.##");
    public static final ResourceLocation bground = new ResourceLocation("Calculator:textures/gui/advancedgreenhouse.png");
    public TileEntityAdvancedGreenhouse entity;

    public GuiAdvancedGreenhouse(InventoryPlayer inventoryPlayer, TileEntityAdvancedGreenhouse entity) {
        super((Container)new ContainerAdvancedGreenhouse(inventoryPlayer, entity), (IWorldPosition)entity);
        this.entity = entity;
        this.field_147000_g = 192;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GreenhouseButton(0, this.field_147003_i + 18, this.field_147009_r + 68, 14, 14, FontHelper.translate((String)"greenhouse.build")));
        this.field_146292_n.add(new GreenhouseButton(1, this.field_147003_i + 36, this.field_147009_r + 68, 14, 14, FontHelper.translate((String)"greenhouse.rebuild")));
        this.field_146292_n.add(new GreenhouseButton(2, this.field_147003_i + 54, this.field_147009_r + 68, 14, 14, FontHelper.translate((String)"greenhouse.demolish")));
        this.field_146292_n.add(new GuiSonarTile.PauseButton((GuiSonarTile)this, (IPausable)this.entity, 3, this.field_147003_i + 8, this.field_147009_r + 8, this.entity.isPaused()));
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null && button instanceof SonarButtons.SonarButton) {
            SonarButtons.SonarButton sButton = (SonarButtons.SonarButton)button;
            sButton.onClicked();
        } else {
            SonarCore.sendPacketToServer((TileEntity)this.entity, (int)button.field_146127_k);
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.entity.houseState.getObject() != TileEntityGreenhouse.State.BUILDING) {
            double car = (double)((Integer)this.entity.carbon.getObject()).intValue() * 100.0 / (double)this.entity.maxLevel;
            String carbon = this.dec.format(car) + '%';
            FontHelper.textOffsetCentre((String)carbon, (int)115, (int)79, (int)2);
            double oxy = (double)this.entity.getOxygen() * 100.0 / (double)this.entity.maxLevel;
            String oxygen = this.dec.format(oxy) + '%';
            FontHelper.textOffsetCentre((String)oxygen, (int)151, (int)79, (int)2);
        }
        for (GuiButton b : this.field_146292_n) {
            if (!(b instanceof GreenhouseButton)) continue;
            GreenhouseButton button = (GreenhouseButton)b;
            if (x < button.field_146128_h || y < button.field_146129_i || x >= button.field_146128_h + button.field_146120_f || y >= button.field_146129_i + button.field_146121_g) continue;
            this.drawSonarCreativeTabHoveringText(FontHelper.translate((String)button.name), x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        int e = this.entity.storage.getEnergyStored() * 46 / this.entity.storage.getMaxEnergyStored();
        this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 46 + 11 - e, 176, 46 - e, 14, 46);
        if (((Boolean)this.entity.wasBuilt.getObject()).booleanValue()) {
            int c = (Integer)this.entity.carbon.getObject() * 66 / this.entity.maxLevel;
            this.func_73729_b(this.field_147003_i + 101, this.field_147009_r + 11 + 66 - c, 190, 66 - c, 28, 66);
            int o = this.entity.getOxygen() * 66 / this.entity.maxLevel;
            this.func_73729_b(this.field_147003_i + 137, this.field_147009_r + 11 + 66 - o, 218, 66 - o, 28, 66);
        }
        GL11.glDisable((int)2896);
        if (((ItemStack)this.entity.slots().get(1)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150476_ad, 64), this.field_147003_i + 12 - 4 + 9, this.field_147009_r + 33 - 4);
        }
        if (((ItemStack)this.entity.slots().get(2)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150476_ad, 64), this.field_147003_i + 30 - 4 + 9, this.field_147009_r + 33 - 4);
        }
        if (((ItemStack)this.entity.slots().get(3)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150476_ad, 52), this.field_147003_i + 48 - 4 + 9, this.field_147009_r + 33 - 4);
        }
        if (((ItemStack)this.entity.slots().get(0)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150364_r, 30), this.field_147003_i + 30 - 4 + 9, this.field_147009_r + 15 - 4);
        }
        if (((ItemStack)this.entity.slots().get(4)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150359_w, 64), this.field_147003_i + 12 - 4 + 9, this.field_147009_r + 51 - 4);
        }
        if (((ItemStack)this.entity.slots().get(5)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150359_w, 26), this.field_147003_i + 30 - 4 + 9, this.field_147009_r + 51 - 4);
        }
        if (((ItemStack)this.entity.slots().get(6)).func_190926_b()) {
            this.field_146296_j.func_175042_a(new ItemStack(Blocks.field_150344_f, 40), this.field_147003_i + 48 - 4 + 9, this.field_147009_r + 51 - 4);
        }
        GL11.glEnable((int)2896);
        RenderHelper.func_74520_c();
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    @SideOnly(value=Side.CLIENT)
    public class GreenhouseButton
    extends GuiButton {
        public String name;

        public GreenhouseButton(int id, int x, int y, int texX, int texY, String name) {
            super(id, x, y, texX, texY, name);
            this.name = name;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        }
    }
}

