/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.gui.machines;

import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import sonar.calculator.mod.common.containers.ContainerDualOutputSmelting;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.api.machines.IPausable;
import sonar.core.client.gui.GuiSonarTile;
import sonar.core.client.gui.SonarButtons;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.IWorldPosition;

public class GuiDualOutputSmelting
extends GuiSonarTile {
    public TileEntityAbstractProcess entity;

    public GuiDualOutputSmelting(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
        super((Container)new ContainerDualOutputSmelting(inventoryPlayer, entity), (IWorldPosition)entity);
        this.entity = entity;
    }

    public ResourceLocation getBackground() {
        return new ResourceLocation("Calculator:textures/gui/stoneseperator.png");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiSonarTile.CircuitButton((GuiSonarTile)this, this.entity.getUpgradeInventory(), 0, this.field_147003_i + 149, this.field_147009_r + 23));
        this.field_146292_n.add(new GuiSonarTile.PauseButton((GuiSonarTile)this, (IPausable)this.entity, 1, this.field_147003_i + 8, this.field_147009_r + 23, this.entity.isPaused()));
    }

    public void initGui(boolean pause) {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiSonarTile.CircuitButton((GuiSonarTile)this, this.entity.getUpgradeInventory(), 0, this.field_147003_i + 149, this.field_147009_r + 23));
        this.field_146292_n.add(new GuiSonarTile.PauseButton((GuiSonarTile)this, (IPausable)this.entity, 1, this.field_147003_i + 8, this.field_147009_r + 23, pause));
    }

    protected void func_146284_a(GuiButton button) {
        if (this.entity.func_145831_w().field_72995_K && button != null && button instanceof SonarButtons.SonarButton) {
            SonarButtons.SonarButton sButton = (SonarButtons.SonarButton)button;
            sButton.onClicked();
        }
    }

    public void func_146979_b(int x, int y) {
        FontHelper.textCentre((String)this.entity.func_70005_c_(), (int)this.field_146999_f, (int)6, (int)0);
        FontHelper.textCentre((String)FontHelper.formatStorage((long)this.entity.storage.getEnergyStored()), (int)this.field_146999_f, (int)64, (int)2);
        if (x > this.field_147003_i + 130 && x < this.field_147003_i + 144 && y > this.field_147009_r + 60 && y < this.field_147009_r + 74) {
            ArrayList<String> list = new ArrayList<String>();
            DecimalFormat df = new DecimalFormat("#.##");
            list.add(TextFormatting.BLUE + "" + TextFormatting.UNDERLINE + "Machine Stats");
            list.add("Stored: " + this.entity.storage.getEnergyStored() + " RF");
            list.add("Usage: " + df.format(this.entity.getEnergyUsage()) + " rf/t");
            list.add("Speed: " + this.entity.getProcessTime() + " ticks");
            this.drawSpecialToolTip(list, x, y, this.field_146289_q);
        }
        super.func_146979_b(x, y);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        int k = this.entity.storage.getEnergyStored() * 78 / this.entity.storage.getMaxEnergyStored();
        int j = 78 - k;
        this.func_73729_b(this.field_147003_i + 49, this.field_147009_r + 63, 176, 0, k, 10);
        if (this.entity.currentSpeed != 0 && (Integer)this.entity.cookTime.getObject() != 0) {
            int l = (Integer)this.entity.cookTime.getObject() * 23 / this.entity.currentSpeed;
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 24, 176, 10, l, 16);
        }
    }

    public static class PrecisionChamber
    extends GuiDualOutputSmelting {
        public PrecisionChamber(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }

        @Override
        public ResourceLocation getBackground() {
            return new ResourceLocation("Calculator:textures/gui/extractionchamber.png");
        }
    }

    public static class ExtractionChamber
    extends GuiDualOutputSmelting {
        public ExtractionChamber(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }

        @Override
        public ResourceLocation getBackground() {
            return new ResourceLocation("Calculator:textures/gui/extractionchamber.png");
        }
    }

    public static class StoneSeperator
    extends GuiDualOutputSmelting {
        public StoneSeperator(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }
    }

    public static class AlgorithmSeperator
    extends GuiDualOutputSmelting {
        public AlgorithmSeperator(InventoryPlayer inventoryPlayer, TileEntityAbstractProcess entity) {
            super(inventoryPlayer, entity);
        }
    }
}

