/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.core.common.block.properties.IMetaRenderer;
import sonar.core.common.block.properties.IMetaVariant;

public class MaterialBlock
extends Block
implements IMetaRenderer {
    public static final PropertyEnum<Variants> VARIANTS = PropertyEnum.func_177709_a((String)"variant", Variants.class);

    public Variants[] getVariants() {
        return Variants.values();
    }

    public Variants getVariant(int metadata) {
        for (Variants colour : Variants.values()) {
            if (colour.meta != metadata) continue;
            return colour;
        }
        return Variants.AMETHYST;
    }

    public MaterialBlock() {
        super(Material.field_151576_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (state.func_177229_b(VARIANTS) == Variants.END_DIAMOND) {
            for (int l = 0; l < 3; ++l) {
                double d6 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                d6 = (float)pos.func_177952_p() + rand.nextFloat();
                int i1 = rand.nextInt(2) * 2 - 1;
                int j1 = rand.nextInt(2) * 2 - 1;
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.125;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.125;
                double d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j1;
                d5 = rand.nextFloat() * 1.0f * (float)j1;
                double d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)i1;
                d3 = rand.nextFloat() * 1.0f * (float)i1;
                world.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((Variants)((Object)state.func_177229_b(VARIANTS))).getMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.getVariants().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANTS, (Comparable)((Object)this.getVariant(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Variants)((Object)state.func_177229_b(VARIANTS))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    public static enum Variants implements IStringSerializable,
    IMetaVariant
    {
        AMETHYST(0),
        TANZANITE(1),
        ENRICHED_GOLD(2),
        REINFORCED_IRON(3),
        WEAKENED_DIAMOND(4),
        FLAWLESS_DIAMOND(5),
        FIRE_DIAMOND(6),
        ELECTRIC_DIAMOND(7),
        END_DIAMOND(8),
        REDSTONE_INGOT(9);

        private int meta;

        private Variants(int meta) {
            this.meta = meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.meta;
        }

        public Item getBaseItem() {
            switch (this) {
                case AMETHYST: {
                    return Calculator.large_amethyst;
                }
                case ELECTRIC_DIAMOND: {
                    return Calculator.electricDiamond;
                }
                case END_DIAMOND: {
                    return Calculator.endDiamond;
                }
                case ENRICHED_GOLD: {
                    return Calculator.enrichedgold_ingot;
                }
                case FIRE_DIAMOND: {
                    return Calculator.firediamond;
                }
                case FLAWLESS_DIAMOND: {
                    return Calculator.flawlessdiamond;
                }
                case REDSTONE_INGOT: {
                    return Calculator.redstone_ingot;
                }
                case REINFORCED_IRON: {
                    return Calculator.reinforcediron_ingot;
                }
                case TANZANITE: {
                    return Calculator.large_tanzanite;
                }
                case WEAKENED_DIAMOND: {
                    return Calculator.weakeneddiamond;
                }
            }
            return null;
        }
    }
}

