/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.generators;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.generators.TileEntityCalculatorLocator;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.SonarCore;
import sonar.core.api.blocks.IStableBlock;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;

public class CalculatorLocator
extends SonarMachineBlock {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public CalculatorLocator() {
        super(SonarMaterials.machine, false, true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean isFullCube() {
        return false;
    }

    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        if (player != null && !world.field_72995_K) {
            TileEntity locator = world.func_175625_s(pos);
            if (locator != null) {
                SonarCore.sendFullSyncAround((TileEntity)locator, (int)64);
            }
            player.openGui((Object)Calculator.instance, -2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        TileEntity target = world.func_175625_s(pos);
        if (target != null && target instanceof TileEntityCalculatorLocator) {
            TileEntityCalculatorLocator locator = (TileEntityCalculatorLocator)target;
            if (((Boolean)locator.active.getObject()).booleanValue()) {
                float x1 = (float)pos.func_177958_n() + random.nextFloat();
                float y1 = (float)pos.func_177956_o() + 0.5f;
                float z1 = (float)pos.func_177952_p() + random.nextFloat();
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public static int multiBlockStructure(World world, BlockPos pos) {
        for (int size = 1; size < 12; ++size) {
            if (!CalculatorLocator.checkSize(world, pos, size)) continue;
            return size;
        }
        return 0;
    }

    public static boolean checkSize(World world, BlockPos pos, int size) {
        int Z;
        int X;
        for (X = -size; X <= size; ++X) {
            for (Z = -size; Z <= size; ++Z) {
                if (X == 0 && Z == 0 || world.func_180495_p(pos.func_177982_a(X, -1, Z)).func_177230_c() instanceof IStableBlock) continue;
                return false;
            }
        }
        for (int XZ = -size; XZ <= size; ++XZ) {
            for (int Y = -1; Y <= 0; ++Y) {
                if (!(world.func_180495_p(pos.func_177982_a(XZ, Y, size + 1)).func_177230_c() instanceof IStableBlock)) {
                    return false;
                }
                if (!(world.func_180495_p(pos.func_177982_a(XZ, Y, -(size + 1))).func_177230_c() instanceof IStableBlock)) {
                    return false;
                }
                if (!(world.func_180495_p(pos.func_177982_a(size + 1, Y, XZ)).func_177230_c() instanceof IStableBlock)) {
                    return false;
                }
                if (world.func_180495_p(pos.func_177982_a(-(size + 1), Y, XZ)).func_177230_c() instanceof IStableBlock) continue;
                return false;
            }
        }
        for (X = -size; X <= size; ++X) {
            for (Z = -size; Z <= size; ++Z) {
                if (X == 0 && Z == 0 || world.func_180495_p(pos.func_177982_a(X, 0, Z)).func_177230_c() == Calculator.calculatorplug) continue;
                return false;
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityCalculatorLocator();
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List<String> list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list) {
        CalculatorHelper.addEnergytoToolTip(stack, world, list);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }
}

