/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityFlawlessGreenhouse;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.api.blocks.IConnectedBlock;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.FailedCoords;

public class FlawlessGreenhouse
extends SonarMachineBlock
implements IConnectedBlock {
    public int[] connections = new int[]{0, 5, 6};

    public FlawlessGreenhouse() {
        super(SonarMaterials.machine, true, true);
    }

    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFlawlessGreenhouse) {
            TileEntityFlawlessGreenhouse house = (TileEntityFlawlessGreenhouse)tile;
            if (interact.type == BlockInteractionType.SHIFT_RIGHT) {
                if (house.houseState.getObject() == TileEntityGreenhouse.State.INCOMPLETE) {
                    FailedCoords coords = house.checkStructure(null);
                    if (!coords.getBoolean()) {
                        FontHelper.sendMessage((String)("X: " + coords.getCoords().getX() + " Y: " + coords.getCoords().getY() + " Z: " + coords.getCoords().getZ() + " - " + FontHelper.translate((String)"greenhouse.equal") + ' ' + coords.getBlock()), (World)world, (EntityPlayer)player);
                    }
                } else if (house.houseState.getObject() == TileEntityGreenhouse.State.COMPLETED) {
                    FontHelper.sendMessage((String)FontHelper.translate((String)"greenhouse.complete"), (World)world, (EntityPlayer)player);
                }
            } else if (player != null && !world.field_72995_K) {
                player.openGui((Object)Calculator.instance, -2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityFlawlessGreenhouse();
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List<String> list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list) {
        CalculatorHelper.addEnergytoToolTip(stack, world, list);
    }

    public int[] getConnections() {
        return this.connections;
    }
}

