/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.machines;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.TileEntityBuildingGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityAdvancedGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityBasicGreenhouse;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.FailedCoords;

public abstract class Greenhouse
extends SonarMachineBlock {
    public Greenhouse() {
        super(SonarMaterials.machine, true, true);
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    /*
     * Enabled aggressive block sorting
     */
    public boolean operateBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, BlockInteraction interact) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityBuildingGreenhouse)) return true;
        TileEntityBuildingGreenhouse house = (TileEntityBuildingGreenhouse)tile;
        if (interact.type != BlockInteractionType.SHIFT_RIGHT) {
            if (player == null) return true;
            if (world.field_72995_K) return true;
            player.openGui((Object)Calculator.instance, -2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (house.houseState.getObject() == TileEntityGreenhouse.State.INCOMPLETE) {
            if (!((Boolean)house.wasBuilt.getObject()).booleanValue()) {
                if (house.storage.getEnergyStored() < house.requiredBuildEnergy) {
                    FontHelper.sendMessage((String)FontHelper.translate((String)"energy.notEnough"), (World)world, (EntityPlayer)player);
                    return true;
                }
                if (!house.hasRequiredStacks()) {
                    FontHelper.sendMessage((String)house.getRequiredStacks().toString(), (World)world, (EntityPlayer)player);
                    return true;
                }
                if (house.houseState.getObject() == TileEntityGreenhouse.State.INCOMPLETE && !((Boolean)house.wasBuilt.getObject()).booleanValue()) {
                    FailedCoords coords = house.createBlock();
                    if (!coords.getBoolean()) {
                        FontHelper.sendMessage((String)(FontHelper.translate((String)"greenhouse.block") + ' ' + "X: " + coords.getCoords().getX() + " Y: " + coords.getCoords().getY() + " Z: " + coords.getCoords().getZ() + " - " + FontHelper.translate((String)"greenhouse.blocking")), (World)world, (EntityPlayer)player);
                        return true;
                    }
                    FontHelper.sendMessage((String)FontHelper.translate((String)"greenhouse.construction"), (World)world, (EntityPlayer)player);
                    return true;
                }
            } else {
                FailedCoords coords = house.checkStructure(TileEntityGreenhouse.GreenhouseAction.CHECK);
                if (!coords.getBoolean()) {
                    FontHelper.sendMessage((String)("X: " + coords.getCoords().getX() + " Y: " + coords.getCoords().getY() + " Z: " + coords.getCoords().getZ() + " - " + FontHelper.translate((String)"greenhouse.equal") + ' ' + coords.getBlock()), (World)world, (EntityPlayer)player);
                    return true;
                }
            }
        }
        if (house.houseState.getObject() != TileEntityGreenhouse.State.COMPLETED) return true;
        FontHelper.sendMessage((ITextComponent)new TextComponentTranslation("greenhouse.complete", new Object[0]), (World)world, (EntityPlayer)player);
        return true;
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List<String> list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
        CalculatorHelper.addGasToolTip(stack, player, list);
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list) {
        CalculatorHelper.addEnergytoToolTip(stack, world, list);
        CalculatorHelper.addGasToolTip(stack, world, list);
    }

    public static class Basic
    extends Greenhouse {
        @Override
        public TileEntity func_149915_a(World var1, int var2) {
            return new TileEntityBasicGreenhouse();
        }
    }

    public static class Advanced
    extends Greenhouse {
        @Override
        public TileEntity func_149915_a(World var1, int var2) {
            return new TileEntityAdvancedGreenhouse();
        }
    }
}

