/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators;

import cofh.redstoneflux.api.IEnergyContainerItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IFlawlessCalculator;
import sonar.calculator.mod.api.items.IModuleProvider;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.api.modules.IModuleClickable;
import sonar.calculator.mod.api.modules.IModuleEnergy;
import sonar.calculator.mod.api.modules.IModuleInventory;
import sonar.calculator.mod.api.modules.IModuleUpdate;
import sonar.calculator.mod.common.item.calculators.modules.EmptyModule;
import sonar.calculator.mod.common.item.calculators.modules.EnergyModule;
import sonar.calculator.mod.common.item.calculators.modules.GuiModule;
import sonar.core.api.energy.ISonarEnergyItem;
import sonar.core.api.utils.ActionType;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.item.InventoryItem;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.IItemInventory;
import sonar.core.utils.IGuiItem;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux")})
public class FlawlessCalculator
extends SonarItem
implements IItemInventory,
IModuleProvider,
ISonarEnergyItem,
IEnergyContainerItem,
IFlawlessCalculator,
IGuiItem {
    public final String invTag = "inv";
    public final String emptyModule = "";
    public static final int moduleCapacity = 16;

    public FlawlessCalculator() {
        this.func_77625_d(1);
    }

    public NBTTagCompound getDefaultTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("slot0", GuiModule.flawless.getName());
        tag.func_74778_a("slot1", GuiModule.dynamic.getName());
        tag.func_74778_a("slot2", GuiModule.crafting.getName());
        tag.func_74778_a("slot3", GuiModule.storage.getName());
        tag.func_74778_a("slot4", new EnergyModule().getName());
        return tag;
    }

    @Override
    public int getCurrentSlot(ItemStack stack) {
        NBTTagCompound tag = this.getTagCompound(stack);
        return tag.func_74762_e("slot");
    }

    public IModule getModuleInSlot(ItemStack stack, int slot) {
        NBTTagCompound tag = this.getTagCompound(stack);
        try {
            IModule module;
            String moduleName = tag.func_74779_i("slot" + slot);
            if (!moduleName.isEmpty() && !moduleName.equals("") && (module = (IModule)Calculator.modules.getRegisteredObject(moduleName)) != null) {
                return module;
            }
        }
        catch (Exception exception) {
            Calculator.logger.error("Flawless Calculator: encountered a null error retrieving a module");
        }
        return EmptyModule.EMPTY;
    }

    @Override
    public IModule getCurrentModule(ItemStack stack) {
        return this.getModuleInSlot(stack, this.getCurrentSlot(stack));
    }

    @Override
    public ArrayList<IModule> getModules(ItemStack stack) {
        ArrayList<IModule> list = new ArrayList<IModule>();
        for (int i = 0; i < 16; ++i) {
            list.add(i, this.getModuleInSlot(stack, i));
        }
        return list;
    }

    public InventoryItem getInventory(ItemStack stack) {
        IModule module = this.getCurrentModule(stack);
        int slot = this.getCurrentSlot(stack);
        if (!(module instanceof IModuleInventory)) {
            return null;
        }
        return ((IModuleInventory)module).getInventory(stack, String.valueOf(slot), false);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        ArrayList<IModule> modules = this.getModules(stack);
        int slot = 0;
        for (IModule module : modules) {
            if (module instanceof IModuleUpdate) {
                NBTTagCompound tag = stack.func_179543_a(String.valueOf(slot));
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                ((IModuleUpdate)module).onUpdate(stack, tag, world, entity);
                if (!tag.func_82582_d()) {
                    stack.func_77983_a(String.valueOf(slot), (NBTBase)tag);
                }
            }
            ++slot;
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tag = this.getTagCompound(stack);
        if (!player.func_70093_af()) {
            int slot = this.getCurrentSlot(stack);
            IModule module = this.getCurrentModule(stack);
            tag = stack.func_179543_a(String.valueOf(slot));
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if (module instanceof IModuleClickable) {
                ((IModuleClickable)module).onModuleActivated(stack, tag, world, player);
            } else if (module instanceof IModuleEnergy) {
                IModuleEnergy energy = (IModuleEnergy)module;
                FontHelper.sendMessage((String)("Energy Module: " + energy.getEnergyStored(stack, tag) + " RF"), (World)world, (EntityPlayer)player);
            }
            if (!tag.func_82582_d() && !world.field_72995_K) {
                stack.func_77983_a(String.valueOf(slot), (NBTBase)tag);
            }
        } else if (!world.field_72995_K) {
            player.openGui((Object)Calculator.instance, 5, world, -1000, -1000, -1000);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IModule module = this.getCurrentModule(stack);
        int slot = this.getCurrentSlot(stack);
        if (module instanceof IModuleClickable) {
            NBTTagCompound tag = stack.func_179543_a(String.valueOf(slot));
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            boolean toReturn = ((IModuleClickable)module).onBlockClicked(stack, tag, player, world, pos, new BlockInteraction(side.func_176745_a(), hitX, hitY, hitZ, BlockInteractionType.RIGHT));
            if (!tag.func_82582_d()) {
                stack.func_77983_a(String.valueOf(slot), (NBTBase)tag);
            }
            return toReturn ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        IModule current = this.getCurrentModule(stack);
        list.add("Current Module: " + current.getClientName());
        long energyStored = 0L;
        long itemsStored = 0L;
        int slot = 0;
        for (IModule module : (ArrayList)this.getModules(stack).clone()) {
            if (module instanceof IModuleEnergy) {
                energyStored += ((IModuleEnergy)module).getEnergyStored(stack, stack.func_190925_c(String.valueOf(slot)));
            } else if (module instanceof IModuleInventory) {
                itemsStored += (long)((IModuleInventory)module).getInventory(stack, String.valueOf(slot), false).getItemsStored(stack);
            }
            ++slot;
        }
        list.add(FontHelper.translate((String)"energy.stored") + ": " + energyStored + " RF");
        if (itemsStored != 0L) {
            list.add(FontHelper.translate((String)"calc.storedstacks") + ": " + itemsStored);
        }
    }

    public long addEnergy(ItemStack stack, long maxReceive, ActionType action) {
        long received = maxReceive;
        int slot = 0;
        for (IModule module : (ArrayList)this.getModules(stack).clone()) {
            if (module instanceof IModuleEnergy) {
                received -= ((IModuleEnergy)module).receiveEnergy(stack, stack.func_190925_c(String.valueOf(slot)), maxReceive, action);
            }
            ++slot;
        }
        return maxReceive - received;
    }

    public long removeEnergy(ItemStack stack, long maxExtract, ActionType action) {
        long extracted = maxExtract;
        int slot = 0;
        for (IModule module : (ArrayList)this.getModules(stack).clone()) {
            if (module instanceof IModuleEnergy) {
                extracted -= ((IModuleEnergy)module).extractEnergy(stack, stack.func_190925_c(String.valueOf(slot)), maxExtract, action);
            }
            ++slot;
        }
        return maxExtract - extracted;
    }

    public long getEnergyLevel(ItemStack stack) {
        long stored = 0L;
        int slot = 0;
        for (IModule module : (ArrayList)this.getModules(stack).clone()) {
            if (module instanceof IModuleEnergy) {
                stored += ((IModuleEnergy)module).getEnergyStored(stack, stack.func_190925_c(String.valueOf(slot)));
            }
            ++slot;
        }
        return stored;
    }

    public long getFullCapacity(ItemStack stack) {
        long stored = 0L;
        int slot = 0;
        for (IModule module : (ArrayList)this.getModules(stack).clone()) {
            if (module instanceof IModuleEnergy) {
                stored += ((IModuleEnergy)module).getMaxEnergyStored(stack, stack.func_190925_c(String.valueOf(slot)));
            }
            ++slot;
        }
        return stored;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)this.addEnergy(container, maxReceive, ActionType.getTypeForAction((boolean)simulate));
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)this.removeEnergy(container, maxExtract, ActionType.getTypeForAction((boolean)simulate));
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack container) {
        return (int)this.getEnergyLevel(container);
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack container) {
        return (int)this.getFullCapacity(container);
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, EntityPlayer player) {
        return super.onDroppedByPlayer(itemstack, player);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    public ItemStack removeModule(ItemStack stack, int slot) {
        IModule module = this.getModuleInSlot(stack, slot);
        NBTTagCompound tag = stack.func_179543_a(String.valueOf(slot));
        stack.func_77983_a(String.valueOf(slot), (NBTBase)new NBTTagCompound());
        stack.func_77978_p().func_74778_a("slot" + slot, "");
        ItemStack toReturn = new ItemStack((Item)Calculator.moduleItems.getPrimaryObject(module.getName()), 1);
        if (tag != null && !tag.func_82582_d()) {
            toReturn.func_77982_d(tag);
        }
        return toReturn;
    }

    @Override
    public void addModule(ItemStack stack, NBTTagCompound moduleTag, IModule module, int slot) {
        NBTTagCompound tag = this.getTagCompound(stack);
        if (module.getName().equals("Empty")) {
            stack.func_77978_p().func_82580_o("slot" + slot);
        } else {
            tag.func_74778_a("slot" + slot, module.getName());
        }
        stack.func_77982_d(tag);
        if (moduleTag != null && !moduleTag.func_82582_d()) {
            stack.func_77983_a(String.valueOf(slot), (NBTBase)moduleTag);
        } else if (stack.func_77978_p().func_150297_b(String.valueOf(slot), 10)) {
            stack.func_77978_p().func_82580_o(String.valueOf(slot));
        }
    }

    @Override
    public boolean canRemoveModule(ItemStack stack, int slot) {
        IModule module = this.getModuleInSlot(stack, slot);
        if (module.getName().equals("Empty")) {
            return false;
        }
        Item item = (Item)Calculator.moduleItems.getPrimaryObject(module.getName());
        return item != null;
    }

    @Override
    public boolean canAddModule(ItemStack stack, IModule module, int slot) {
        IModule current = this.getModuleInSlot(stack, slot);
        return module.getName().equals("Empty");
    }

    @Override
    public NBTTagCompound getModuleTag(ItemStack stack, int slot) {
        return stack.func_190925_c(String.valueOf(slot));
    }

    public Object getGuiContainer(EntityPlayer player, ItemStack stack) {
        return ((IGuiItem)this.getCurrentModule(stack)).getGuiContainer(player, stack);
    }

    public Object getGuiScreen(EntityPlayer player, ItemStack stack) {
        return ((IGuiItem)this.getCurrentModule(stack)).getGuiScreen(player, stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b() || newStack.func_77952_i() != oldStack.func_77952_i();
    }
}

