/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IModuleProvider;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.api.modules.IModuleClickable;
import sonar.calculator.mod.api.modules.IModuleInventory;
import sonar.calculator.mod.api.modules.IModuleUpdate;
import sonar.core.api.utils.BlockInteraction;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.item.InventoryItem;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.ContainerCraftInventory;
import sonar.core.inventory.IItemInventory;
import sonar.core.utils.IGuiItem;

public class SonarModule
extends SonarItem
implements IItemInventory,
IModuleProvider,
IGuiItem {
    public IModule module;
    public final String invTag = "inv";

    public SonarModule(IModule module) {
        this.module = module;
        this.func_77625_d(1);
    }

    public InventoryItem getInventory(ItemStack stack) {
        if (this.module instanceof IModuleInventory) {
            return ((IModuleInventory)this.module).getInventory(stack, "inv", true);
        }
        Calculator.logger.error("Module: " + this.module.getName() + " doesn't contain an Inventory!");
        return null;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (this.module instanceof IModuleUpdate) {
            NBTTagCompound tag = this.getTagCompound(stack);
            ((IModuleUpdate)this.module).onUpdate(stack, tag, world, entity);
            stack.func_77982_d(tag);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.module instanceof IModuleClickable) {
            NBTTagCompound tag = this.getTagCompound(stack);
            ((IModuleClickable)this.module).onModuleActivated(stack, tag, world, player);
            stack.func_77982_d(tag);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.module instanceof IModuleClickable) {
            NBTTagCompound tag = this.getTagCompound(stack);
            boolean toReturn = ((IModuleClickable)this.module).onBlockClicked(stack, tag, player, world, pos, new BlockInteraction(side.func_176745_a(), hitX, hitY, hitZ, BlockInteractionType.RIGHT));
            stack.func_77982_d(tag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        int items;
        super.func_77624_a(stack, world, list, par4);
        if (this.module instanceof IModuleInventory && (items = ((IModuleInventory)this.module).getInventory(stack, "inv", true).getItemsStored(stack)) != 0) {
            list.add(FontHelper.translate((String)"calc.storedstacks") + ": " + items);
        }
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, EntityPlayer player) {
        if (this.module instanceof IModuleInventory && itemstack != null && player instanceof EntityPlayerMP && player.field_71070_bA instanceof ContainerCraftInventory) {
            player.func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public int func_77626_a(ItemStack stack) {
        return this.module instanceof IModuleInventory ? 1 : super.func_77626_a(stack);
    }

    @Override
    public ArrayList<IModule> getModules(ItemStack stack) {
        return (ArrayList)Collections.singletonList(this.module);
    }

    public Object getGuiContainer(EntityPlayer player, ItemStack stack) {
        return ((IGuiItem)this.module).getGuiContainer(player, stack);
    }

    public Object getGuiScreen(EntityPlayer player, ItemStack stack) {
        return ((IGuiItem)this.module).getGuiScreen(player, stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b() || newStack.func_77952_i() != oldStack.func_77952_i();
    }
}

