/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.modules;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.utils.helpers.NutritionHelper;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;

public class HealthModule
extends SonarItem
implements IHealthStore {
    public HealthModule() {
        this.func_77637_a(Calculator.Calculator);
        this.field_77777_bU = 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        NutritionHelper.chargeHealth(stack, world, player, "points");
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        NutritionHelper.useHealth(stack, player, world, pos, side, "points");
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        if (stack.func_77942_o()) {
            list.add(FontHelper.translate((String)"points.health") + ": " + this.getHealthPoints(stack));
        }
    }

    @Override
    public void transferHealth(int transfer, ItemStack stack, ProcessType process) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a("points", 0);
        }
        int points = stack.func_77978_p().func_74762_e("points");
        if (process == ProcessType.REMOVE) {
            nbtData.func_74768_a("points", points - transfer);
        } else if (process == ProcessType.ADD) {
            nbtData.func_74768_a("points", points + transfer);
        }
    }

    @Override
    public int getHealthPoints(ItemStack stack) {
        return NutritionHelper.getIntegerTag(stack, "points");
    }

    @Override
    public int getMaxHealthPoints(ItemStack stack) {
        return 1000;
    }

    @Override
    public void setHealth(ItemStack stack, int health) {
        if (health >= 0 && health <= this.getMaxHealthPoints(stack)) {
            NBTTagCompound nbtData;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbtData = stack.func_77978_p()) == null) {
                stack.func_77978_p().func_74768_a("points", 0);
            }
            nbtData.func_74768_a("points", health);
        }
    }
}

