/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.tileentity.TileEntityProcess;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.utils.IGuiTile;

public abstract class TileEntityAbstractProcess
extends TileEntityProcess
implements IGuiTile {
    public final int inputSize;
    public final int outputSize;
    public final int baseProcess;
    public final int baseEnergy;

    public TileEntityAbstractProcess(int inputSize, int outputSize, int baseProcess, int baseEnergy) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.baseProcess = baseProcess;
        this.baseEnergy = baseEnergy;
        int[] inputs = new int[inputSize];
        int[] outputs = new int[outputSize];
        for (int i = 0; i < inputSize; ++i) {
            inputs[i] = i;
        }
        for (int o = inputSize; o < inputSize + outputSize; ++o) {
            outputs[o - inputSize] = o + 1;
        }
        this.input = inputs;
        this.output = outputs;
        this.storage.setCapacity(CalculatorConfig.getInteger("Standard Machine")).setMaxTransfer(32000);
        this.inv = new SonarInventory((TileEntity)this, 1 + inputSize + outputSize);
        this.syncList.addPart((IDirtyPart)this.inv);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.discharge(this.inputSize);
    }

    public int inputSize() {
        return this.inputSize;
    }

    public int outputSize() {
        return this.outputSize;
    }

    public int getBaseProcessTime() {
        return this.baseProcess;
    }

    @Override
    public int getBaseEnergyUsage() {
        return this.baseEnergy;
    }

    public RecipeHelperV2 recipeHelper() {
        return null;
    }

    public ISonarRecipe getRecipe(ItemStack[] inputs) {
        return this.recipeHelper().getRecipeFromInputs(null, (Object[])inputs);
    }

    @Override
    public boolean canProcess() {
        if (((ItemStack)this.slots().get(0)).func_190926_b() || (Integer)this.cookTime.getObject() == 0 && this.storage.getEnergyStored() < this.requiredEnergy()) {
            return false;
        }
        ISonarRecipe recipe = this.getRecipe(this.inputStacks());
        if (recipe == null) {
            return false;
        }
        for (int o = 0; o < this.outputSize(); ++o) {
            if (((ISonarRecipeObject)recipe.outputs().get(o)).isNull()) {
                return false;
            }
            ItemStack outputStack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)o);
            ItemStack stackInSlot = (ItemStack)this.slots().get(o + this.inputSize() + 1);
            if (stackInSlot.func_190926_b()) continue;
            if (!stackInSlot.func_77969_a(outputStack)) {
                return false;
            }
            if (stackInSlot.func_190916_E() + outputStack.func_190916_E() <= stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean isOutputVoided(int slot, ItemStack outputStack) {
        return false;
    }

    public int getMaxInputSize() {
        int size = 1;
        for (int i = 0; i < this.inputSize(); ++i) {
            size = ((ItemStack)this.slots().get(i)).func_190926_b() ? Math.max(size, ((ItemStack)this.slots().get(i)).func_190916_E()) : 0;
        }
        return size;
    }

    public int getMaxOutputSize() {
        int size = 1;
        ISonarRecipe recipe = this.getRecipe(this.inputStacks());
        for (int o = 0; o < this.outputSize(); ++o) {
            ISonarRecipeObject outputObject = (ISonarRecipeObject)recipe.outputs().get(o);
            size = ((ItemStack)this.slots().get(o + this.inputSize() + 1)).func_190926_b() && outputObject != null ? Math.max((this.func_70297_j_() - ((ItemStack)this.slots().get(o + this.inputSize() + 1)).func_190916_E()) / outputObject.getStackSize(), size) : 0;
        }
        return size;
    }

    @Override
    public void finishProcess() {
        ISonarRecipe recipe = this.getRecipe(this.inputStacks());
        if (recipe == null) {
            return;
        }
        for (int o = 0; o < Math.min(recipe.outputs().size(), this.outputSize()); ++o) {
            ISonarRecipeObject outputObject = (ISonarRecipeObject)recipe.outputs().get(o);
            ItemStack stack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)o);
            if (stack.func_190926_b() || this.isOutputVoided(o + this.inputSize() + 1, stack)) continue;
            ItemStack stackInSlot = (ItemStack)this.slots().get(o + this.inputSize() + 1);
            if (stackInSlot.func_190926_b()) {
                ItemStack outputStack = stack.func_77946_l();
                if (outputStack.func_77973_b() == Calculator.circuitBoard) {
                    CircuitBoard.setData(outputStack);
                }
                this.slots().set(o + this.inputSize() + 1, outputStack);
                continue;
            }
            if (!stackInSlot.func_77969_a(stack)) continue;
            stackInSlot.func_190917_f(outputObject.getStackSize());
        }
        for (int i = 0; i < Math.min(recipe.inputs().size(), this.inputSize()); ++i) {
            ((ItemStack)this.slots().get(i)).func_190918_g(this.recipeHelper() != null ? ((ISonarRecipeObject)recipe.inputs().get(i)).getStackSize() : 1);
        }
    }

    public ItemStack[] inputStacks() {
        ItemStack[] input = new ItemStack[this.inputSize()];
        for (int i = 0; i < this.inputSize(); ++i) {
            input[i] = (ItemStack)this.slots().get(i);
        }
        return input;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot < this.inputSize() && this.recipeHelper() != null && this.recipeHelper().isValidInput((Object)stack);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack) && this.canStack((ItemStack)this.slots().get(slot), stack);
    }
}

